<?php
function themefarmer_companion_admin_footer_icons_html(){
	$icons =themefarmer_companion_get_menu_icons_array();
	?>
	<div class="themefarmer-basic-icon-panel-overlay" style="display: none;">
		<div class="themefarmer-basic-icon-panel">
			<button type="button" class="media-modal-close"><span class="media-modal-icon"><span class="screen-reader-text"><?php esc_html_e('Close media panel', 'themefarmer-companion'); ?></span></span></button>
			<div class="tf-icon-panel-title"><?php esc_html_e('Select Icon', 'themefarmer-companion'); ?></div>
			<div class="tf-icon-search-bar"><input type="search" id="tf-search-menu-icon" placeholder="<?php esc_html_e('Search Icon'); ?>"></div>
			<div class="tf-icons-picker-panel">
				<span class="themefarmer-icon-picker" title="<?php esc_attr_e('Remove Icon', 'themefarmer-companion'); ?>"><i class=""></i></span>
			<?php 
				if($icons){
					foreach ($icons as $key => $icon){
					echo '<span class="themefarmer-icon-picker" data-icon="'.esc_attr($icon).'"><i class="'.esc_attr($icon).'"></i></span>';
					}
				}
			?>
			</div>
		</div>
	</div>
	<?php
}
add_action('admin_footer', 'themefarmer_companion_admin_footer_icons_html');


function themefarmer_companion_send_mail($to, $subject, $body, $headers){
		$success_message   	= esc_html__('Your email has been sent successfully. We will get in touch soon, Thank You.', 'scope-pro');
		$is_sent = wp_mail($to, $subject, $body, $headers);
		$res_message = $is_sent?$success_message:esc_html__('Error while sending email', 'scope-pro');
		echo json_encode(array('status' => intval($is_sent), 'message' => $res_message));
}

function themefarmer_companion_contact_form_mail() {
	$is_nonce   		= wp_verify_nonce($_POST['skdjodfd93823'], 'lkajsdf9asdfpoi0_nonce');
	$to         		= get_bloginfo('admin_email');
	$afrom_email       	= get_bloginfo('admin_email');
	$afrom_name        	= get_bloginfo('name');

	$subject    = sanitize_text_field($_POST['subject']);
	$body       = wp_filter_post_kses($_POST['message']);
	$from_name  = sanitize_text_field($_POST['name']);
	$from_email = sanitize_email($_POST['email']);
	$headers[]  = "From: $afrom_name <$afrom_email>";
	$headers[]  = "Reply-To: $from_name <$from_email>";
	$body       = "From: $from_name <$from_email> \n ".$body;
	

	if (isset($to) && !empty($to) && is_email($to) && $is_nonce){
		themefarmer_companion_send_mail($to, $subject, $body, $headers);
	}else{
		echo json_encode(array('status' => 0, 'message' => esc_html__('Email is invalid', 'scope-pro')));
	}

	wp_die();
}
add_action('wp_ajax_themefarmer_contact_form_mail', 'themefarmer_companion_contact_form_mail');
add_action( 'wp_ajax_nopriv_themefarmer_contact_form_mail', 'themefarmer_companion_contact_form_mail' );


function themefarmer_get_simple_contact_form() {
	?>
	<div class="contact-form-container">
	    <form name="contact" id="themefarmer-simple-contact-form" method="post">
	        <input type="hidden" name="action" value="themefarmer_contact_form_mail">
	        <?php wp_nonce_field('lkajsdf9asdfpoi0_nonce', 'skdjodfd93823');?>
	        <div class="form-group">
	            <input type="text" name="name" id="name" class="form-control" data-validation="required" placeholder="<?php esc_html_e('Your Name', 'themefarmer-companion')?>" data-validation-error-msg-required="<?php esc_html_e('Name is required', 'themefarmer-companion');?>"/>
	        </div>
	        <div class="form-group">
	            <input type="text" name="email" id="email" class="form-control" data-validation="required, email" placeholder="<?php esc_html_e('Email Address', 'themefarmer-companion')?>" data-validation-error-msg-required="<?php esc_html_e('Email is required', 'themefarmer-companion');?>"  data-validation-error-msg-required="<?php esc_html_e('You have not given a correct e-mail address', 'themefarmer-companion');?>"/>
	        </div>
	        <div class="form-group">
	            <input type="text" name="subject" id="subject" class="form-control" placeholder="<?php esc_html_e('Subject', 'themefarmer-companion')?>"/>
	        </div>
	        <div class="form-group">
	            <textarea name="message" rows="5" id="message" class="form-control" data-validation="required" placeholder="<?php esc_html_e('Message', 'themefarmer-companion')?>" data-validation-error-msg-required="<?php esc_html_e('Message is required', 'themefarmer-companion');?>"></textarea>
	        </div>
	        <div class="form-group row">
	        	<div class="col-md-12">
	            	<button type="submit" class="btn btn-contact-home" id="simple-contact-form-submit-buton"><i id="submit-buton-icon" class="fa fa-paper-plane" aria-hidden="true"></i> <?php esc_html_e('Send Message', 'themefarmer-companion');?> </button>
	            </div>
	        </div>
	    </form>
	    <div id="simple-contact-form-reseponse88"></div>
	</div>
	<?php
}























function themefarmer_companion_get_menu_icons_array(){
	return  array(
		'glass'                               => 'fa fa-glass',
		'music'                               => 'fa fa-music',
		'search'                              => 'fa fa-search',
		'envelope-o'                          => 'fa fa-envelope-o',
		'heart'                               => 'fa fa-heart',
		'star'                                => 'fa fa-star',
		'star-o'                              => 'fa fa-star-o',
		'user'                                => 'fa fa-user',
		'film'                                => 'fa fa-film',
		'th-large'                            => 'fa fa-th-large',
		'th'                                  => 'fa fa-th',
		'th-list'                             => 'fa fa-th-list',
		'check'                               => 'fa fa-check',
		'remove'                              => 'fa fa-remove',
		'close'                               => 'fa fa-close',
		'times'                               => 'fa fa-times',
		'search-plus'                         => 'fa fa-search-plus',
		'search-minus'                        => 'fa fa-search-minus',
		'power-off'                           => 'fa fa-power-off',
		'signal'                              => 'fa fa-signal',
		'gear'                                => 'fa fa-gear',
		'cog'                                 => 'fa fa-cog',
		'trash-o'                             => 'fa fa-trash-o',
		'home'                                => 'fa fa-home',
		'file-o'                              => 'fa fa-file-o',
		'clock-o'                             => 'fa fa-clock-o',
		'road'                                => 'fa fa-road',
		'download'                            => 'fa fa-download',
		'arrow-circle-o-down'                 => 'fa fa-arrow-circle-o-down',
		'arrow-circle-o-up'                   => 'fa fa-arrow-circle-o-up',
		'inbox'                               => 'fa fa-inbox',
		'play-circle-o'                       => 'fa fa-play-circle-o',
		'rotate-right'                        => 'fa fa-rotate-right',
		'repeat'                              => 'fa fa-repeat',
		'refresh'                             => 'fa fa-refresh',
		'list-alt'                            => 'fa fa-list-alt',
		'lock'                                => 'fa fa-lock',
		'flag'                                => 'fa fa-flag',
		'headphones'                          => 'fa fa-headphones',
		'volume-off'                          => 'fa fa-volume-off',
		'volume-down'                         => 'fa fa-volume-down',
		'volume-up'                           => 'fa fa-volume-up',
		'qrcode'                              => 'fa fa-qrcode',
		'barcode'                             => 'fa fa-barcode',
		'tag'                                 => 'fa fa-tag',
		'tags'                                => 'fa fa-tags',
		'book'                                => 'fa fa-book',
		'bookmark'                            => 'fa fa-bookmark',
		'print'                               => 'fa fa-print',
		'camera'                              => 'fa fa-camera',
		'font'                                => 'fa fa-font',
		'bold'                                => 'fa fa-bold',
		'italic'                              => 'fa fa-italic',
		'text-height'                         => 'fa fa-text-height',
		'text-width'                          => 'fa fa-text-width',
		'align-left'                          => 'fa fa-align-left',
		'align-center'                        => 'fa fa-align-center',
		'align-right'                         => 'fa fa-align-right',
		'align-justify'                       => 'fa fa-align-justify',
		'list'                                => 'fa fa-list',
		'dedent'                              => 'fa fa-dedent',
		'outdent'                             => 'fa fa-outdent',
		'indent'                              => 'fa fa-indent',
		'video-camera'                        => 'fa fa-video-camera',
		'photo'                               => 'fa fa-photo',
		'image'                               => 'fa fa-image',
		'picture-o'                           => 'fa fa-picture-o',
		'pencil'                              => 'fa fa-pencil',
		'map-marker'                          => 'fa fa-map-marker',
		'adjust'                              => 'fa fa-adjust',
		'tint'                                => 'fa fa-tint',
		'edit'                                => 'fa fa-edit',
		'pencil-square-o'                     => 'fa fa-pencil-square-o',
		'share-square-o'                      => 'fa fa-share-square-o',
		'check-square-o'                      => 'fa fa-check-square-o',
		'arrows'                              => 'fa fa-arrows',
		'step-backward'                       => 'fa fa-step-backward',
		'fast-backward'                       => 'fa fa-fast-backward',
		'backward'                            => 'fa fa-backward',
		'play'                                => 'fa fa-play',
		'pause'                               => 'fa fa-pause',
		'stop'                                => 'fa fa-stop',
		'forward'                             => 'fa fa-forward',
		'fast-forward'                        => 'fa fa-fast-forward',
		'step-forward'                        => 'fa fa-step-forward',
		'eject'                               => 'fa fa-eject',
		'chevron-left'                        => 'fa fa-chevron-left',
		'chevron-right'                       => 'fa fa-chevron-right',
		'plus-circle'                         => 'fa fa-plus-circle',
		'minus-circle'                        => 'fa fa-minus-circle',
		'times-circle'                        => 'fa fa-times-circle',
		'check-circle'                        => 'fa fa-check-circle',
		'question-circle'                     => 'fa fa-question-circle',
		'info-circle'                         => 'fa fa-info-circle',
		'crosshairs'                          => 'fa fa-crosshairs',
		'times-circle-o'                      => 'fa fa-times-circle-o',
		'check-circle-o'                      => 'fa fa-check-circle-o',
		'ban'                                 => 'fa fa-ban',
		'arrow-left'                          => 'fa fa-arrow-left',
		'arrow-right'                         => 'fa fa-arrow-right',
		'arrow-up'                            => 'fa fa-arrow-up',
		'arrow-down'                          => 'fa fa-arrow-down',
		'mail-forward'                        => 'fa fa-mail-forward',
		'share'                               => 'fa fa-share',
		'expand'                              => 'fa fa-expand',
		'compress'                            => 'fa fa-compress',
		'plus'                                => 'fa fa-plus',
		'minus'                               => 'fa fa-minus',
		'asterisk'                            => 'fa fa-asterisk',
		'exclamation-circle'                  => 'fa fa-exclamation-circle',
		'gift'                                => 'fa fa-gift',
		'leaf'                                => 'fa fa-leaf',
		'fire'                                => 'fa fa-fire',
		'eye'                                 => 'fa fa-eye',
		'eye-slash'                           => 'fa fa-eye-slash',
		'warning'                             => 'fa fa-warning',
		'exclamation-triangle'                => 'fa fa-exclamation-triangle',
		'plane'                               => 'fa fa-plane',
		'calendar'                            => 'fa fa-calendar',
		'random'                              => 'fa fa-random',
		'comment'                             => 'fa fa-comment',
		'magnet'                              => 'fa fa-magnet',
		'chevron-up'                          => 'fa fa-chevron-up',
		'chevron-down'                        => 'fa fa-chevron-down',
		'retweet'                             => 'fa fa-retweet',
		'shopping-cart'                       => 'fa fa-shopping-cart',
		'folder'                              => 'fa fa-folder',
		'folder-open'                         => 'fa fa-folder-open',
		'arrows-v'                            => 'fa fa-arrows-v',
		'arrows-h'                            => 'fa fa-arrows-h',
		'bar-chart-o'                         => 'fa fa-bar-chart-o',
		'bar-chart'                           => 'fa fa-bar-chart',
		'twitter-square'                      => 'fa fa-twitter-square',
		'facebook-square'                     => 'fa fa-facebook-square',
		'camera-retro'                        => 'fa fa-camera-retro',
		'key'                                 => 'fa fa-key',
		'gears'                               => 'fa fa-gears',
		'cogs'                                => 'fa fa-cogs',
		'comments'                            => 'fa fa-comments',
		'thumbs-o-up'                         => 'fa fa-thumbs-o-up',
		'thumbs-o-down'                       => 'fa fa-thumbs-o-down',
		'star-half'                           => 'fa fa-star-half',
		'heart-o'                             => 'fa fa-heart-o',
		'sign-out'                            => 'fa fa-sign-out',
		'linkedin-square'                     => 'fa fa-linkedin-square',
		'thumb-tack'                          => 'fa fa-thumb-tack',
		'external-link'                       => 'fa fa-external-link',
		'sign-in'                             => 'fa fa-sign-in',
		'trophy'                              => 'fa fa-trophy',
		'github-square'                       => 'fa fa-github-square',
		'upload'                              => 'fa fa-upload',
		'lemon-o'                             => 'fa fa-lemon-o',
		'phone'                               => 'fa fa-phone',
		'square-o'                            => 'fa fa-square-o',
		'bookmark-o'                          => 'fa fa-bookmark-o',
		'phone-square'                        => 'fa fa-phone-square',
		'twitter'                             => 'fa fa-twitter',
		'facebook-f'                          => 'fa fa-facebook-f',
		'facebook'                            => 'fa fa-facebook',
		'github'                              => 'fa fa-github',
		'unlock'                              => 'fa fa-unlock',
		'credit-card'                         => 'fa fa-credit-card',
		'feed'                                => 'fa fa-feed',
		'rss'                                 => 'fa fa-rss',
		'hdd-o'                               => 'fa fa-hdd-o',
		'bullhorn'                            => 'fa fa-bullhorn',
		'bell'                                => 'fa fa-bell',
		'certificate'                         => 'fa fa-certificate',
		'hand-o-right'                        => 'fa fa-hand-o-right',
		'hand-o-left'                         => 'fa fa-hand-o-left',
		'hand-o-up'                           => 'fa fa-hand-o-up',
		'hand-o-down'                         => 'fa fa-hand-o-down',
		'arrow-circle-left'                   => 'fa fa-arrow-circle-left',
		'arrow-circle-right'                  => 'fa fa-arrow-circle-right',
		'arrow-circle-up'                     => 'fa fa-arrow-circle-up',
		'arrow-circle-down'                   => 'fa fa-arrow-circle-down',
		'globe'                               => 'fa fa-globe',
		'wrench'                              => 'fa fa-wrench',
		'tasks'                               => 'fa fa-tasks',
		'filter'                              => 'fa fa-filter',
		'briefcase'                           => 'fa fa-briefcase',
		'arrows-alt'                          => 'fa fa-arrows-alt',
		'group'                               => 'fa fa-group',
		'users'                               => 'fa fa-users',
		'chain'                               => 'fa fa-chain',
		'link'                                => 'fa fa-link',
		'cloud'                               => 'fa fa-cloud',
		'flask'                               => 'fa fa-flask',
		'cut'                                 => 'fa fa-cut',
		'scissors'                            => 'fa fa-scissors',
		'copy'                                => 'fa fa-copy',
		'files-o'                             => 'fa fa-files-o',
		'paperclip'                           => 'fa fa-paperclip',
		'save'                                => 'fa fa-save',
		'floppy-o'                            => 'fa fa-floppy-o',
		'square'                              => 'fa fa-square',
		'navicon'                             => 'fa fa-navicon',
		'reorder'                             => 'fa fa-reorder',
		'bars'                                => 'fa fa-bars',
		'list-ul'                             => 'fa fa-list-ul',
		'list-ol'                             => 'fa fa-list-ol',
		'strikethrough'                       => 'fa fa-strikethrough',
		'underline'                           => 'fa fa-underline',
		'table'                               => 'fa fa-table',
		'magic'                               => 'fa fa-magic',
		'truck'                               => 'fa fa-truck',
		'pinterest'                           => 'fa fa-pinterest',
		'pinterest-square'                    => 'fa fa-pinterest-square',
		'google-plus-square'                  => 'fa fa-google-plus-square',
		'google-plus'                         => 'fa fa-google-plus',
		'money'                               => 'fa fa-money',
		'caret-down'                          => 'fa fa-caret-down',
		'caret-up'                            => 'fa fa-caret-up',
		'caret-left'                          => 'fa fa-caret-left',
		'caret-right'                         => 'fa fa-caret-right',
		'columns'                             => 'fa fa-columns',
		'unsorted'                            => 'fa fa-unsorted',
		'sort'                                => 'fa fa-sort',
		'sort-down'                           => 'fa fa-sort-down',
		'sort-desc'                           => 'fa fa-sort-desc',
		'sort-up'                             => 'fa fa-sort-up',
		'sort-asc'                            => 'fa fa-sort-asc',
		'envelope'                            => 'fa fa-envelope',
		'linkedin'                            => 'fa fa-linkedin',
		'rotate-left'                         => 'fa fa-rotate-left',
		'undo'                                => 'fa fa-undo',
		'legal'                               => 'fa fa-legal',
		'gavel'                               => 'fa fa-gavel',
		'dashboard'                           => 'fa fa-dashboard',
		'tachometer'                          => 'fa fa-tachometer',
		'comment-o'                           => 'fa fa-comment-o',
		'comments-o'                          => 'fa fa-comments-o',
		'flash'                               => 'fa fa-flash',
		'bolt'                                => 'fa fa-bolt',
		'sitemap'                             => 'fa fa-sitemap',
		'umbrella'                            => 'fa fa-umbrella',
		'paste'                               => 'fa fa-paste',
		'clipboard'                           => 'fa fa-clipboard',
		'lightbulb-o'                         => 'fa fa-lightbulb-o',
		'exchange'                            => 'fa fa-exchange',
		'cloud-download'                      => 'fa fa-cloud-download',
		'cloud-upload'                        => 'fa fa-cloud-upload',
		'user-md'                             => 'fa fa-user-md',
		'stethoscope'                         => 'fa fa-stethoscope',
		'suitcase'                            => 'fa fa-suitcase',
		'bell-o'                              => 'fa fa-bell-o',
		'coffee'                              => 'fa fa-coffee',
		'cutlery'                             => 'fa fa-cutlery',
		'file-text-o'                         => 'fa fa-file-text-o',
		'building-o'                          => 'fa fa-building-o',
		'hospital-o'                          => 'fa fa-hospital-o',
		'ambulance'                           => 'fa fa-ambulance',
		'medkit'                              => 'fa fa-medkit',
		'fighter-jet'                         => 'fa fa-fighter-jet',
		'beer'                                => 'fa fa-beer',
		'h-square'                            => 'fa fa-h-square',
		'plus-square'                         => 'fa fa-plus-square',
		'angle-double-left'                   => 'fa fa-angle-double-left',
		'angle-double-right'                  => 'fa fa-angle-double-right',
		'angle-double-up'                     => 'fa fa-angle-double-up',
		'angle-double-down'                   => 'fa fa-angle-double-down',
		'angle-left'                          => 'fa fa-angle-left',
		'angle-right'                         => 'fa fa-angle-right',
		'angle-up'                            => 'fa fa-angle-up',
		'angle-down'                          => 'fa fa-angle-down',
		'desktop'                             => 'fa fa-desktop',
		'laptop'                              => 'fa fa-laptop',
		'tablet'                              => 'fa fa-tablet',
		'mobile-phone'                        => 'fa fa-mobile-phone',
		'mobile'                              => 'fa fa-mobile',
		'circle-o'                            => 'fa fa-circle-o',
		'quote-left'                          => 'fa fa-quote-left',
		'quote-right'                         => 'fa fa-quote-right',
		'spinner'                             => 'fa fa-spinner',
		'circle'                              => 'fa fa-circle',
		'mail-reply'                          => 'fa fa-mail-reply',
		'reply'                               => 'fa fa-reply',
		'github-alt'                          => 'fa fa-github-alt',
		'folder-o'                            => 'fa fa-folder-o',
		'folder-open-o'                       => 'fa fa-folder-open-o',
		'smile-o'                             => 'fa fa-smile-o',
		'frown-o'                             => 'fa fa-frown-o',
		'meh-o'                               => 'fa fa-meh-o',
		'gamepad'                             => 'fa fa-gamepad',
		'keyboard-o'                          => 'fa fa-keyboard-o',
		'flag-o'                              => 'fa fa-flag-o',
		'flag-checkered'                      => 'fa fa-flag-checkered',
		'terminal'                            => 'fa fa-terminal',
		'code'                                => 'fa fa-code',
		'mail-reply-all'                      => 'fa fa-mail-reply-all',
		'reply-all'                           => 'fa fa-reply-all',
		'star-half-empty'                     => 'fa fa-star-half-empty',
		'star-half-full'                      => 'fa fa-star-half-full',
		'star-half-o'                         => 'fa fa-star-half-o',
		'location-arrow'                      => 'fa fa-location-arrow',
		'crop'                                => 'fa fa-crop',
		'code-fork'                           => 'fa fa-code-fork',
		'unlink'                              => 'fa fa-unlink',
		'chain-broken'                        => 'fa fa-chain-broken',
		'question'                            => 'fa fa-question',
		'info'                                => 'fa fa-info',
		'exclamation'                         => 'fa fa-exclamation',
		'superscript'                         => 'fa fa-superscript',
		'subscript'                           => 'fa fa-subscript',
		'eraser'                              => 'fa fa-eraser',
		'puzzle-piece'                        => 'fa fa-puzzle-piece',
		'microphone'                          => 'fa fa-microphone',
		'microphone-slash'                    => 'fa fa-microphone-slash',
		'shield'                              => 'fa fa-shield',
		'calendar-o'                          => 'fa fa-calendar-o',
		'fire-extinguisher'                   => 'fa fa-fire-extinguisher',
		'rocket'                              => 'fa fa-rocket',
		'maxcdn'                              => 'fa fa-maxcdn',
		'chevron-circle-left'                 => 'fa fa-chevron-circle-left',
		'chevron-circle-right'                => 'fa fa-chevron-circle-right',
		'chevron-circle-up'                   => 'fa fa-chevron-circle-up',
		'chevron-circle-down'                 => 'fa fa-chevron-circle-down',
		'html5'                               => 'fa fa-html5',
		'css3'                                => 'fa fa-css3',
		'anchor'                              => 'fa fa-anchor',
		'unlock-alt'                          => 'fa fa-unlock-alt',
		'bullseye'                            => 'fa fa-bullseye',
		'ellipsis-h'                          => 'fa fa-ellipsis-h',
		'ellipsis-v'                          => 'fa fa-ellipsis-v',
		'rss-square'                          => 'fa fa-rss-square',
		'play-circle'                         => 'fa fa-play-circle',
		'ticket'                              => 'fa fa-ticket',
		'minus-square'                        => 'fa fa-minus-square',
		'minus-square-o'                      => 'fa fa-minus-square-o',
		'level-up'                            => 'fa fa-level-up',
		'level-down'                          => 'fa fa-level-down',
		'check-square'                        => 'fa fa-check-square',
		'pencil-square'                       => 'fa fa-pencil-square',
		'external-link-square'                => 'fa fa-external-link-square',
		'share-square'                        => 'fa fa-share-square',
		'compass'                             => 'fa fa-compass',
		'toggle-down'                         => 'fa fa-toggle-down',
		'caret-square-o-down'                 => 'fa fa-caret-square-o-down',
		'toggle-up'                           => 'fa fa-toggle-up',
		'caret-square-o-up'                   => 'fa fa-caret-square-o-up',
		'toggle-right'                        => 'fa fa-toggle-right',
		'caret-square-o-right'                => 'fa fa-caret-square-o-right',
		'euro'                                => 'fa fa-euro',
		'eur'                                 => 'fa fa-eur',
		'gbp'                                 => 'fa fa-gbp',
		'dollar'                              => 'fa fa-dollar',
		'usd'                                 => 'fa fa-usd',
		'rupee'                               => 'fa fa-rupee',
		'inr'                                 => 'fa fa-inr',
		'cny'                                 => 'fa fa-cny',
		'rmb'                                 => 'fa fa-rmb',
		'yen'                                 => 'fa fa-yen',
		'jpy'                                 => 'fa fa-jpy',
		'ruble'                               => 'fa fa-ruble',
		'rouble'                              => 'fa fa-rouble',
		'rub'                                 => 'fa fa-rub',
		'won'                                 => 'fa fa-won',
		'krw'                                 => 'fa fa-krw',
		'bitcoin'                             => 'fa fa-bitcoin',
		'btc'                                 => 'fa fa-btc',
		'file'                                => 'fa fa-file',
		'file-text'                           => 'fa fa-file-text',
		'sort-alpha-asc'                      => 'fa fa-sort-alpha-asc',
		'sort-alpha-desc'                     => 'fa fa-sort-alpha-desc',
		'sort-amount-asc'                     => 'fa fa-sort-amount-asc',
		'sort-amount-desc'                    => 'fa fa-sort-amount-desc',
		'sort-numeric-asc'                    => 'fa fa-sort-numeric-asc',
		'sort-numeric-desc'                   => 'fa fa-sort-numeric-desc',
		'thumbs-up'                           => 'fa fa-thumbs-up',
		'thumbs-down'                         => 'fa fa-thumbs-down',
		'youtube-square'                      => 'fa fa-youtube-square',
		'youtube'                             => 'fa fa-youtube',
		'xing'                                => 'fa fa-xing',
		'xing-square'                         => 'fa fa-xing-square',
		'youtube-play'                        => 'fa fa-youtube-play',
		'dropbox'                             => 'fa fa-dropbox',
		'stack-overflow'                      => 'fa fa-stack-overflow',
		'instagram'                           => 'fa fa-instagram',
		'flickr'                              => 'fa fa-flickr',
		'adn'                                 => 'fa fa-adn',
		'bitbucket'                           => 'fa fa-bitbucket',
		'bitbucket-square'                    => 'fa fa-bitbucket-square',
		'tumblr'                              => 'fa fa-tumblr',
		'tumblr-square'                       => 'fa fa-tumblr-square',
		'long-arrow-down'                     => 'fa fa-long-arrow-down',
		'long-arrow-up'                       => 'fa fa-long-arrow-up',
		'long-arrow-left'                     => 'fa fa-long-arrow-left',
		'long-arrow-right'                    => 'fa fa-long-arrow-right',
		'apple'                               => 'fa fa-apple',
		'windows'                             => 'fa fa-windows',
		'android'                             => 'fa fa-android',
		'linux'                               => 'fa fa-linux',
		'dribbble'                            => 'fa fa-dribbble',
		'skype'                               => 'fa fa-skype',
		'foursquare'                          => 'fa fa-foursquare',
		'trello'                              => 'fa fa-trello',
		'female'                              => 'fa fa-female',
		'male'                                => 'fa fa-male',
		'gittip'                              => 'fa fa-gittip',
		'gratipay'                            => 'fa fa-gratipay',
		'sun-o'                               => 'fa fa-sun-o',
		'moon-o'                              => 'fa fa-moon-o',
		'archive'                             => 'fa fa-archive',
		'bug'                                 => 'fa fa-bug',
		'vk'                                  => 'fa fa-vk',
		'weibo'                               => 'fa fa-weibo',
		'renren'                              => 'fa fa-renren',
		'pagelines'                           => 'fa fa-pagelines',
		'stack-exchange'                      => 'fa fa-stack-exchange',
		'arrow-circle-o-right'                => 'fa fa-arrow-circle-o-right',
		'arrow-circle-o-left'                 => 'fa fa-arrow-circle-o-left',
		'toggle-left'                         => 'fa fa-toggle-left',
		'caret-square-o-left'                 => 'fa fa-caret-square-o-left',
		'dot-circle-o'                        => 'fa fa-dot-circle-o',
		'wheelchair'                          => 'fa fa-wheelchair',
		'vimeo-square'                        => 'fa fa-vimeo-square',
		'turkish-lira'                        => 'fa fa-turkish-lira',
		'try'                                 => 'fa fa-try',
		'plus-square-o'                       => 'fa fa-plus-square-o',
		'space-shuttle'                       => 'fa fa-space-shuttle',
		'slack'                               => 'fa fa-slack',
		'envelope-square'                     => 'fa fa-envelope-square',
		'wordpress'                           => 'fa fa-wordpress',
		'openid'                              => 'fa fa-openid',
		'institution'                         => 'fa fa-institution',
		'bank'                                => 'fa fa-bank',
		'university'                          => 'fa fa-university',
		'mortar-board'                        => 'fa fa-mortar-board',
		'graduation-cap'                      => 'fa fa-graduation-cap',
		'yahoo'                               => 'fa fa-yahoo',
		'google'                              => 'fa fa-google',
		'reddit'                              => 'fa fa-reddit',
		'reddit-square'                       => 'fa fa-reddit-square',
		'stumbleupon-circle'                  => 'fa fa-stumbleupon-circle',
		'stumbleupon'                         => 'fa fa-stumbleupon',
		'delicious'                           => 'fa fa-delicious',
		'digg'                                => 'fa fa-digg',
		'pied-piper-pp'                       => 'fa fa-pied-piper-pp',
		'pied-piper-alt'                      => 'fa fa-pied-piper-alt',
		'drupal'                              => 'fa fa-drupal',
		'joomla'                              => 'fa fa-joomla',
		'language'                            => 'fa fa-language',
		'fax'                                 => 'fa fa-fax',
		'building'                            => 'fa fa-building',
		'child'                               => 'fa fa-child',
		'paw'                                 => 'fa fa-paw',
		'spoon'                               => 'fa fa-spoon',
		'cube'                                => 'fa fa-cube',
		'cubes'                               => 'fa fa-cubes',
		'behance'                             => 'fa fa-behance',
		'behance-square'                      => 'fa fa-behance-square',
		'steam'                               => 'fa fa-steam',
		'steam-square'                        => 'fa fa-steam-square',
		'recycle'                             => 'fa fa-recycle',
		'automobile'                          => 'fa fa-automobile',
		'car'                                 => 'fa fa-car',
		'cab'                                 => 'fa fa-cab',
		'taxi'                                => 'fa fa-taxi',
		'tree'                                => 'fa fa-tree',
		'spotify'                             => 'fa fa-spotify',
		'deviantart'                          => 'fa fa-deviantart',
		'soundcloud'                          => 'fa fa-soundcloud',
		'database'                            => 'fa fa-database',
		'file-pdf-o'                          => 'fa fa-file-pdf-o',
		'file-word-o'                         => 'fa fa-file-word-o',
		'file-excel-o'                        => 'fa fa-file-excel-o',
		'file-powerpoint-o'                   => 'fa fa-file-powerpoint-o',
		'file-photo-o'                        => 'fa fa-file-photo-o',
		'file-picture-o'                      => 'fa fa-file-picture-o',
		'file-image-o'                        => 'fa fa-file-image-o',
		'file-zip-o'                          => 'fa fa-file-zip-o',
		'file-archive-o'                      => 'fa fa-file-archive-o',
		'file-sound-o'                        => 'fa fa-file-sound-o',
		'file-audio-o'                        => 'fa fa-file-audio-o',
		'file-movie-o'                        => 'fa fa-file-movie-o',
		'file-video-o'                        => 'fa fa-file-video-o',
		'file-code-o'                         => 'fa fa-file-code-o',
		'vine'                                => 'fa fa-vine',
		'codepen'                             => 'fa fa-codepen',
		'jsfiddle'                            => 'fa fa-jsfiddle',
		'life-bouy'                           => 'fa fa-life-bouy',
		'life-buoy'                           => 'fa fa-life-buoy',
		'life-saver'                          => 'fa fa-life-saver',
		'support'                             => 'fa fa-support',
		'life-ring'                           => 'fa fa-life-ring',
		'circle-o-notch'                      => 'fa fa-circle-o-notch',
		'ra'                                  => 'fa fa-ra',
		'resistance'                          => 'fa fa-resistance',
		'rebel'                               => 'fa fa-rebel',
		'ge'                                  => 'fa fa-ge',
		'empire'                              => 'fa fa-empire',
		'git-square'                          => 'fa fa-git-square',
		'git'                                 => 'fa fa-git',
		'y-combinator-square'                 => 'fa fa-y-combinator-square',
		'yc-square'                           => 'fa fa-yc-square',
		'hacker-news'                         => 'fa fa-hacker-news',
		'tencent-weibo'                       => 'fa fa-tencent-weibo',
		'qq'                                  => 'fa fa-qq',
		'wechat'                              => 'fa fa-wechat',
		'weixin'                              => 'fa fa-weixin',
		'send'                                => 'fa fa-send',
		'paper-plane'                         => 'fa fa-paper-plane',
		'send-o'                              => 'fa fa-send-o',
		'paper-plane-o'                       => 'fa fa-paper-plane-o',
		'history'                             => 'fa fa-history',
		'circle-thin'                         => 'fa fa-circle-thin',
		'header'                              => 'fa fa-header',
		'paragraph'                           => 'fa fa-paragraph',
		'sliders'                             => 'fa fa-sliders',
		'share-alt'                           => 'fa fa-share-alt',
		'share-alt-square'                    => 'fa fa-share-alt-square',
		'bomb'                                => 'fa fa-bomb',
		'soccer-ball-o'                       => 'fa fa-soccer-ball-o',
		'futbol-o'                            => 'fa fa-futbol-o',
		'tty'                                 => 'fa fa-tty',
		'binoculars'                          => 'fa fa-binoculars',
		'plug'                                => 'fa fa-plug',
		'slideshare'                          => 'fa fa-slideshare',
		'twitch'                              => 'fa fa-twitch',
		'yelp'                                => 'fa fa-yelp',
		'newspaper-o'                         => 'fa fa-newspaper-o',
		'wifi'                                => 'fa fa-wifi',
		'calculator'                          => 'fa fa-calculator',
		'paypal'                              => 'fa fa-paypal',
		'google-wallet'                       => 'fa fa-google-wallet',
		'cc-visa'                             => 'fa fa-cc-visa',
		'cc-mastercard'                       => 'fa fa-cc-mastercard',
		'cc-discover'                         => 'fa fa-cc-discover',
		'cc-amex'                             => 'fa fa-cc-amex',
		'cc-paypal'                           => 'fa fa-cc-paypal',
		'cc-stripe'                           => 'fa fa-cc-stripe',
		'bell-slash'                          => 'fa fa-bell-slash',
		'bell-slash-o'                        => 'fa fa-bell-slash-o',
		'trash'                               => 'fa fa-trash',
		'copyright'                           => 'fa fa-copyright',
		'at'                                  => 'fa fa-at',
		'eyedropper'                          => 'fa fa-eyedropper',
		'paint-brush'                         => 'fa fa-paint-brush',
		'birthday-cake'                       => 'fa fa-birthday-cake',
		'area-chart'                          => 'fa fa-area-chart',
		'pie-chart'                           => 'fa fa-pie-chart',
		'line-chart'                          => 'fa fa-line-chart',
		'lastfm'                              => 'fa fa-lastfm',
		'lastfm-square'                       => 'fa fa-lastfm-square',
		'toggle-off'                          => 'fa fa-toggle-off',
		'toggle-on'                           => 'fa fa-toggle-on',
		'bicycle'                             => 'fa fa-bicycle',
		'bus'                                 => 'fa fa-bus',
		'ioxhost'                             => 'fa fa-ioxhost',
		'angellist'                           => 'fa fa-angellist',
		'cc'                                  => 'fa fa-cc',
		'shekel'                              => 'fa fa-shekel',
		'sheqel'                              => 'fa fa-sheqel',
		'ils'                                 => 'fa fa-ils',
		'meanpath'                            => 'fa fa-meanpath',
		'buysellads'                          => 'fa fa-buysellads',
		'connectdevelop'                      => 'fa fa-connectdevelop',
		'dashcube'                            => 'fa fa-dashcube',
		'forumbee'                            => 'fa fa-forumbee',
		'leanpub'                             => 'fa fa-leanpub',
		'sellsy'                              => 'fa fa-sellsy',
		'shirtsinbulk'                        => 'fa fa-shirtsinbulk',
		'simplybuilt'                         => 'fa fa-simplybuilt',
		'skyatlas'                            => 'fa fa-skyatlas',
		'cart-plus'                           => 'fa fa-cart-plus',
		'cart-arrow-down'                     => 'fa fa-cart-arrow-down',
		'diamond'                             => 'fa fa-diamond',
		'ship'                                => 'fa fa-ship',
		'user-secret'                         => 'fa fa-user-secret',
		'motorcycle'                          => 'fa fa-motorcycle',
		'street-view'                         => 'fa fa-street-view',
		'heartbeat'                           => 'fa fa-heartbeat',
		'venus'                               => 'fa fa-venus',
		'mars'                                => 'fa fa-mars',
		'mercury'                             => 'fa fa-mercury',
		'intersex'                            => 'fa fa-intersex',
		'transgender'                         => 'fa fa-transgender',
		'transgender-alt'                     => 'fa fa-transgender-alt',
		'venus-double'                        => 'fa fa-venus-double',
		'mars-double'                         => 'fa fa-mars-double',
		'venus-mars'                          => 'fa fa-venus-mars',
		'mars-stroke'                         => 'fa fa-mars-stroke',
		'mars-stroke-v'                       => 'fa fa-mars-stroke-v',
		'mars-stroke-h'                       => 'fa fa-mars-stroke-h',
		'neuter'                              => 'fa fa-neuter',
		'genderless'                          => 'fa fa-genderless',
		'facebook-official'                   => 'fa fa-facebook-official',
		'pinterest-p'                         => 'fa fa-pinterest-p',
		'whatsapp'                            => 'fa fa-whatsapp',
		'server'                              => 'fa fa-server',
		'user-plus'                           => 'fa fa-user-plus',
		'user-times'                          => 'fa fa-user-times',
		'hotel'                               => 'fa fa-hotel',
		'bed'                                 => 'fa fa-bed',
		'viacoin'                             => 'fa fa-viacoin',
		'train'                               => 'fa fa-train',
		'subway'                              => 'fa fa-subway',
		'medium'                              => 'fa fa-medium',
		'yc'                                  => 'fa fa-yc',
		'y-combinator'                        => 'fa fa-y-combinator',
		'optin-monster'                       => 'fa fa-optin-monster',
		'opencart'                            => 'fa fa-opencart',
		'expeditedssl'                        => 'fa fa-expeditedssl',
		'battery-4'                           => 'fa fa-battery-4',
		'battery-full'                        => 'fa fa-battery-full',
		'battery-3'                           => 'fa fa-battery-3',
		'battery-three-quarters'              => 'fa fa-battery-three-quarters',
		'battery-2'                           => 'fa fa-battery-2',
		'battery-half'                        => 'fa fa-battery-half',
		'battery-1'                           => 'fa fa-battery-1',
		'battery-quarter'                     => 'fa fa-battery-quarter',
		'battery-0'                           => 'fa fa-battery-0',
		'battery-empty'                       => 'fa fa-battery-empty',
		'mouse-pointer'                       => 'fa fa-mouse-pointer',
		'i-cursor'                            => 'fa fa-i-cursor',
		'object-group'                        => 'fa fa-object-group',
		'object-ungroup'                      => 'fa fa-object-ungroup',
		'sticky-note'                         => 'fa fa-sticky-note',
		'sticky-note-o'                       => 'fa fa-sticky-note-o',
		'cc-jcb'                              => 'fa fa-cc-jcb',
		'cc-diners-club'                      => 'fa fa-cc-diners-club',
		'clone'                               => 'fa fa-clone',
		'balance-scale'                       => 'fa fa-balance-scale',
		'hourglass-o'                         => 'fa fa-hourglass-o',
		'hourglass-1'                         => 'fa fa-hourglass-1',
		'hourglass-start'                     => 'fa fa-hourglass-start',
		'hourglass-2'                         => 'fa fa-hourglass-2',
		'hourglass-half'                      => 'fa fa-hourglass-half',
		'hourglass-3'                         => 'fa fa-hourglass-3',
		'hourglass-end'                       => 'fa fa-hourglass-end',
		'hourglass'                           => 'fa fa-hourglass',
		'hand-grab-o'                         => 'fa fa-hand-grab-o',
		'hand-rock-o'                         => 'fa fa-hand-rock-o',
		'hand-stop-o'                         => 'fa fa-hand-stop-o',
		'hand-paper-o'                        => 'fa fa-hand-paper-o',
		'hand-scissors-o'                     => 'fa fa-hand-scissors-o',
		'hand-lizard-o'                       => 'fa fa-hand-lizard-o',
		'hand-spock-o'                        => 'fa fa-hand-spock-o',
		'hand-pointer-o'                      => 'fa fa-hand-pointer-o',
		'hand-peace-o'                        => 'fa fa-hand-peace-o',
		'trademark'                           => 'fa fa-trademark',
		'registered'                          => 'fa fa-registered',
		'creative-commons'                    => 'fa fa-creative-commons',
		'gg'                                  => 'fa fa-gg',
		'gg-circle'                           => 'fa fa-gg-circle',
		'tripadvisor'                         => 'fa fa-tripadvisor',
		'odnoklassniki'                       => 'fa fa-odnoklassniki',
		'odnoklassniki-square'                => 'fa fa-odnoklassniki-square',
		'get-pocket'                          => 'fa fa-get-pocket',
		'wikipedia-w'                         => 'fa fa-wikipedia-w',
		'safari'                              => 'fa fa-safari',
		'chrome'                              => 'fa fa-chrome',
		'firefox'                             => 'fa fa-firefox',
		'opera'                               => 'fa fa-opera',
		'internet-explorer'                   => 'fa fa-internet-explorer',
		'tv'                                  => 'fa fa-tv',
		'television'                          => 'fa fa-television',
		'contao'                              => 'fa fa-contao',
		'500px'                               => 'fa fa-500px',
		'amazon'                              => 'fa fa-amazon',
		'calendar-plus-o'                     => 'fa fa-calendar-plus-o',
		'calendar-minus-o'                    => 'fa fa-calendar-minus-o',
		'calendar-times-o'                    => 'fa fa-calendar-times-o',
		'calendar-check-o'                    => 'fa fa-calendar-check-o',
		'industry'                            => 'fa fa-industry',
		'map-pin'                             => 'fa fa-map-pin',
		'map-signs'                           => 'fa fa-map-signs',
		'map-o'                               => 'fa fa-map-o',
		'map'                                 => 'fa fa-map',
		'commenting'                          => 'fa fa-commenting',
		'commenting-o'                        => 'fa fa-commenting-o',
		'houzz'                               => 'fa fa-houzz',
		'vimeo'                               => 'fa fa-vimeo',
		'black-tie'                           => 'fa fa-black-tie',
		'fonticons'                           => 'fa fa-fonticons',
		'reddit-alien'                        => 'fa fa-reddit-alien',
		'edge'                                => 'fa fa-edge',
		'credit-card-alt'                     => 'fa fa-credit-card-alt',
		'codiepie'                            => 'fa fa-codiepie',
		'modx'                                => 'fa fa-modx',
		'fort-awesome'                        => 'fa fa-fort-awesome',
		'usb'                                 => 'fa fa-usb',
		'product-hunt'                        => 'fa fa-product-hunt',
		'mixcloud'                            => 'fa fa-mixcloud',
		'scribd'                              => 'fa fa-scribd',
		'pause-circle'                        => 'fa fa-pause-circle',
		'pause-circle-o'                      => 'fa fa-pause-circle-o',
		'stop-circle'                         => 'fa fa-stop-circle',
		'stop-circle-o'                       => 'fa fa-stop-circle-o',
		'shopping-bag'                        => 'fa fa-shopping-bag',
		'shopping-basket'                     => 'fa fa-shopping-basket',
		'hashtag'                             => 'fa fa-hashtag',
		'bluetooth'                           => 'fa fa-bluetooth',
		'bluetooth-b'                         => 'fa fa-bluetooth-b',
		'percent'                             => 'fa fa-percent',
		'gitlab'                              => 'fa fa-gitlab',
		'wpbeginner'                          => 'fa fa-wpbeginner',
		'wpforms'                             => 'fa fa-wpforms',
		'envira'                              => 'fa fa-envira',
		'universal-access'                    => 'fa fa-universal-access',
		'wheelchair-alt'                      => 'fa fa-wheelchair-alt',
		'question-circle-o'                   => 'fa fa-question-circle-o',
		'blind'                               => 'fa fa-blind',
		'audio-description'                   => 'fa fa-audio-description',
		'volume-control-phone'                => 'fa fa-volume-control-phone',
		'braille'                             => 'fa fa-braille',
		'assistive-listening-systems'         => 'fa fa-assistive-listening-systems',
		'asl-interpreting'                    => 'fa fa-asl-interpreting',
		'american-sign-language-interpreting' => 'fa fa-american-sign-language-interpreting',
		'deafness'                            => 'fa fa-deafness',
		'hard-of-hearing'                     => 'fa fa-hard-of-hearing',
		'deaf'                                => 'fa fa-deaf',
		'glide'                               => 'fa fa-glide',
		'glide-g'                             => 'fa fa-glide-g',
		'signing'                             => 'fa fa-signing',
		'sign-language'                       => 'fa fa-sign-language',
		'low-vision'                          => 'fa fa-low-vision',
		'viadeo'                              => 'fa fa-viadeo',
		'viadeo-square'                       => 'fa fa-viadeo-square',
		'snapchat'                            => 'fa fa-snapchat',
		'snapchat-ghost'                      => 'fa fa-snapchat-ghost',
		'snapchat-square'                     => 'fa fa-snapchat-square',
		'pied-piper'                          => 'fa fa-pied-piper',
		'first-order'                         => 'fa fa-first-order',
		'yoast'                               => 'fa fa-yoast',
		'themeisle'                           => 'fa fa-themeisle',
		'google-plus-circle'                  => 'fa fa-google-plus-circle',
		'google-plus-official'                => 'fa fa-google-plus-official',
		'fa'                                  => 'fa fa-fa',
		'font-awesome'                        => 'fa fa-font-awesome',
	);
}