<?php
/**
 * Check if PHP short tags are used
 *
 * @package Theme Check
 */

/**
 * Check if PHP short tags are used.
 */
class PHP_Short_Tags_Check implements themecheck {
	/**
	 * Error messages, warnings and info notices.
	 *
	 * @var array $error
	 */
	protected $error = array();

	/**
	 * Check that return true for good/okay/acceptable, false for bad/not-okay/unacceptable.
	 *
	 * @param array $php_files File paths and content for PHP files.
	 * @param array $css_files File paths and content for CSS files.
	 * @param array $other_files Folder names, file paths and content for other files.
	 */
	public function check( $php_files, $css_files, $other_files ) {

		foreach ( $php_files as $file_path => $file_content ) {
			checkcount();

			if ( preg_match( '/<\?(\=?)(?!php|xml)/i', $file_content ) ) {
				$grep          = tc_preg( '/<\?(\=?)(?!php|xml)/', $file_path );
				$this->error[] = sprintf(
					'<span class="tc-lead tc-warning">%s</span>: %s %s',
					__( 'WARNING', 'theme-check' ),
					sprintf(
						__( 'Found PHP short tags in file %s.', 'theme-check' ),
						'<strong>' . tc_filename( $file_path ) . '</strong>'
					),
					$grep
				);
			}
		}

		return true;
	}

	/**
	 * Get error messages from the checks.
	 *
	 * @return array Error message.
	 */
	public function getError() {
		return $this->error;
	}
}

$themechecks[] = new PHP_Short_Tags_Check();
