<?php
/* Block : Creative Image
 * @since : 1.2.0
 */
defined( 'ABSPATH' ) || exit;

function tpgb_tp_creative_image_callback( $settings, $content) {
	
	$block_id	= !empty($settings['block_id']) ? $settings['block_id'] : '';
	$fancyBox = (!empty($settings['fancyBox'])) ? $settings['fancyBox'] : false;
	$floatAlign = !empty($settings['floatAlign']) ? $settings['floatAlign'] : '';
	$blockClass = Tp_Blocks_Helper::block_wrapper_classes( $settings );
	
	// Float Align Class
	if(!empty($floatAlign) && $floatAlign!='none'){
		$blockClass .= 'tpgb-image-'.esc_attr($floatAlign);
	}

	$contentImage = $imgID ='';
	$altText = (isset($settings['SelectImg']['alt']) && !empty($settings['SelectImg']['alt'])) ? esc_attr($settings['SelectImg']['alt']) : ((!empty($settings['SelectImg']['title'])) ? esc_attr($settings['SelectImg']['title']) : esc_attr__('Creative Image','the-plus-addons-for-block-editor'));
	if ( isset( $settings['SelectImg']['id'] ) && !empty($settings['SelectImg']['id'])) {
		$imgID = $settings['SelectImg']['id'];
	}
	if ( ! empty( $settings['SelectImg']['url'] ) && isset( $settings['SelectImg']['id'] ) ) {
		$attr = array( 'class' => "hover__img info_img", 'alt' => $altText );
		$contentImage = wp_get_attachment_image($imgID, $settings['ImgSize'],"",$attr);				
	} else { 
		$contentImage .= tpgb_loading_image_grid(get_the_ID());
	}
	
	$href = $target = $rel = '';
	if (!empty($settings['link']['url'])) {
		$href  = ($settings['link']['url'] !== '' ) ? $settings['link']['url'] : ''; 
		$target  = (!empty($settings['link']['target'])) ? 'target="_blank"' : ''; 
		$rel = (!empty($settings['link']['nofollow'])) ? 'rel="nofollow"' : '';
	}

	$maskImage='';
	if(!empty($settings["showMaskImg"])){
		$maskImage=' tpgb-creative-mask-media';
	}
	$wrapperClass='tpgb-creative-img-wrap '.esc_attr($maskImage);

	$dataImage='';
	$fancyImg = TPGB_ASSETS_URL. 'assets/images/tpgb-placeholder.jpg';
	if(isset($settings['SelectImg']['id'])) {
		$fullImage = wp_get_attachment_image_src( $imgID, 'full' );
		$fancyImg= isset($fullImage[0]) ? $fullImage[0] : '';
		$dataImage = (!empty($fullImage) && !empty($fullImage[0])) ? 'background: url('.esc_url($fullImage[0]).');' : '';
	} else {
		$dataImage = tpgb_loading_image_grid('','background');
	}
	
	$data_settings = '';
	if(!empty($fancyBox)){
        $FancyData = (!empty($settings['FancyOption'])) ? json_decode($settings['FancyOption']) : [];
        $button = array();
        if (is_array($FancyData) || is_object($FancyData)) {
            foreach ($FancyData as $value) {
                $buttonOpt = (($value->value == 'zoom') ? 'iterateZoom' : (($value->value == 'fullScreen') ? 'fullscreen' : $value->value));
                if($value->value != 'share'){
                    $button[] = $buttonOpt;
                }
            }
        }
        $fancybox = array();
        $fancybox['button'] = $button;
		// $fancybox['animationEffect'] = $settings['AnimationFancy'];
		// $fancybox['animationDuration'] = $settings['DurationFancy'];
        $data_settings .= ' data-fancy-option=\''.json_encode($fancybox).'\'';
        $data_settings .= ' data-id="'.esc_attr($block_id).'"';
    }
	
	if ( ! empty( $settings['link']['url'] ) ) {
		$link_attr = Tp_Blocks_Helper::add_link_attributes($settings['link']);
		$ariaLabelT = (!empty($settings['ariaLabel'])) ? esc_attr($settings['ariaLabel']) : esc_attr__('Creative Image','the-plus-addons-for-block-editor');
		$html = '<a href="'.esc_url($href).'" '.$target.' '.$rel.' class="'.esc_attr($wrapperClass).'" '.$link_attr.' aria-label="'.$ariaLabelT.'">' .$contentImage. '</a>';
	} else {
		$tag = !empty($fancyBox) && empty($settings['ScrollParallax']) ? 'a' : 'div';
		$fancyAttr =  !empty($fancyBox) ? 'href= "'.esc_url($fancyImg).'" data-fancybox="fancyImg-'.esc_attr($block_id).'"' : '';
		
		$html = '<'.Tp_Blocks_Helper::validate_html_tag($tag).' class="' . esc_attr($wrapperClass) . '" '.$fancyAttr.'>' .$contentImage. '</'.Tp_Blocks_Helper::validate_html_tag($tag).'>';
	}

	$uid= 'bg-image'.esc_attr($block_id);
	$animatedClass='';
	$cssClass = '';
	$cssClass = ' text-' . esc_attr($settings["Alignment"]['md']) . ' '.esc_attr($animatedClass);
	$cssClass .= (!empty($settings["Alignment"]['sm'])) ? ' text-tablet-' . esc_attr($settings["Alignment"]['sm']) : '';
	$cssClass .= (!empty($settings["Alignment"]['xs'])) ? ' text-mobile-' . esc_attr($settings["Alignment"]['xs']) : '';

	$uidWidget = 'plus'.esc_attr($block_id);
	$output = '<div id="'.esc_attr($uidWidget).'" class="tpgb-creative-image tpgb-relative-block tpgb-block-'.esc_attr($block_id).' '.esc_attr($blockClass).'">';
		$output .= '<div class="tpgb-anim-img-parallax tpgb-relative-block" >';
			$output .= '<div class="tpgb-animate-image '.esc_attr($uid).' ' . trim( $cssClass ) . ' '.(!empty($fancyBox) ? 'tpgb-fancy-add' : '').'" '.$data_settings.'>';
				$output .= '<figure>';
					$output .= $html;
				$output .= '</figure>';
			$output .='</div>';
		$output .= '</div>';
	$output .= '</div>';
	
	$output = Tpgb_Blocks_Global_Options::block_Wrap_Render($settings, $output);
	
	return $output;
}

function tpgb_tp_creative_image_render() {
	$block_data = Tpgb_Blocks_Global_Options::merge_options_json(__DIR__, 'tpgb_tp_creative_image_callback');
	register_block_type( $block_data['name'], $block_data );
}
add_action( 'init', 'tpgb_tp_creative_image_render' );

function tpgb_loading_image_grid($postid = '', $type = '') {
	global $post;
	$contentImage = '';
	if($type!='background'){		
		$imageUrl = TPGB_ASSETS_URL. 'assets/images/tpgb-placeholder.jpg';
		$contentImage = '<img src="'.esc_url($imageUrl).'" alt="'.esc_attr(get_the_title()).'"/>';
		return $contentImage;
	} elseif($type == 'background') {
		$imageUrl = TPGB_ASSETS_URL. 'assets/images/tpgb-placeholder.jpg';
		$dataSrc = "background:url(".esc_url($imageUrl).") #f7f7f7;";
		return $dataSrc;
	}
}