<?php
namespace ThePackAddon\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Utils;

if (!defined('ABSPATH')) {
    exit;
} // Exit if accessed directly

class thepack_videobgpop extends Widget_Base
{
    public function get_name()
    {
        return 'tbbgvid';
    }

    public function get_title()
    {
        return esc_html__('Video Pop 2', 'the-pack-addon');
    }

    public function get_icon()
    {
        return 'dashicons dashicons-nametag';
    }

    public function get_categories()
    {
        return ['ashelement-addons'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_heading',
            [
                'label' => esc_html__('Video Popup', 'the-pack-addon'),
            ]
        );

        $this->add_control(
            'url',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label' => esc_html__('Url', 'the-pack-addon'),
                'label_block' => true,
                'default' => 'https://www.youtube.com/watch?v=ET_hFOSg3Ss',
                'description' => esc_html__('Video embed url', 'the-pack-addon'),
            ]
        );

        $this->add_control(
            'heading',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Heading', 'the-pack-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'sub',
            [
                'type' => Controls_Manager::TEXT,
                'label' => esc_html__('Sub heading', 'the-pack-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'icon',
            [
                'type' => Controls_Manager::ICONS,
                'label' => esc_html__('Play Icon', 'the-pack-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'close',
            [
                'type' => Controls_Manager::ICONS,
                'label' => esc_html__('Popup close icon', 'the-pack-addon'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__('General', 'the-pack-addon'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => esc_html__('Alignment', 'the-pack-addon'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'the-pack-addon'),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'the-pack-addon'),
                        'icon' => 'eicon-v-align-top',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'the-pack-addon'),
                        'icon' => 'eicon-h-align-right',
                    ]
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .tp-video-pop' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'overlay_color',
                'types' => ['none', 'classic', 'gradient'],
                'selector' => '{{WRAPPER}} .vidbg',
				'fields_options' => [
					'background' => [
						'label' => esc_html__( 'Background','the-pack-addon' ),
					]
				]                
            ] 
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'hovbgx',
                'types' => ['none', 'classic', 'gradient'],
                'selector' => '{{WRAPPER}} .vidbg:hover',
				'fields_options' => [
					'background' => [
						'label' => esc_html__( 'Hover background','the-pack-addon' ),
					]
				]                
            ]
        );

        $this->add_control(
            'vidplklr',
            [
                'label' => esc_html__('Pulse animation color', 'the-pack-addon'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tpvideopop:after' => 'background: {{VALUE}};'
                ],
            ]
        );

        $this->add_responsive_control(
            'bblr',
            [
                'label' => esc_html__('Background blur', 'the-pack-addon'),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .vidbg' => 'backdrop-filter: blur({{SIZE}}{{UNIT}});',
                ],

            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_image',
            [
                'label' => esc_html__('Content', 'the-pack-addon'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('tctb');

        $this->start_controls_tab(
            'e1',
            [
                'label' => esc_html__('Icon', 'the-pack-addon'),
            ]
        );

        $this->add_responsive_control(
            'vibgw',
            [
                'label' => esc_html__('Video box width', 'the-pack-addon'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ],
                ],
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .vidbg' => 'width:{{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'vibgwr',
            [
                'label' => esc_html__('Border radius', 'the-pack-addon'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ],
                ],
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .vidbg,{{WRAPPER}} .tpvideopop:after' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]  
        );

        $this->add_control(
            'vbxbc',
            [
                'label' => esc_html__('Border color', 'the-pack-addon'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vidbg' => 'border-color: {{VALUE}};border-style:solid;'
                ],
            ]
        );

        $this->add_responsive_control(
            'vbewid',
            [
                'label' => esc_html__('Border width', 'the-pack-addon'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .vidbg' => 'border-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_c',
            [
                'label' => esc_html__('Icon color', 'the-pack-addon'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tbicon' => 'color: {{VALUE}};'
                ],
            ]
        );
        $this->add_control(
            'icong_c',
            [
                'label' => esc_html__('Hover color', 'the-pack-addon'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .vidbg:hover .tbicon' => 'color: {{VALUE}};'
                ],
            ]
        );
        $this->add_control(
            'btn_size',
            [
                'label' => esc_html__('Icon font size', 'the-pack-addon'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .tbicon' => 'font-size: {{SIZE}}px;',
                ],
            ]
        );

        $this->add_control(
            'vps',
            [
                'label' => esc_html__('Vertical position', 'the-pack-addon'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => -100,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .tbicon' => 'top: {{SIZE}}px;',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'e2',
            [
                'label' => esc_html__('Text', 'the-pack-addon'),
            ]
        );

        $this->add_responsive_control(
            'clspc',
            [
                'label' => esc_html__('Left spacing', 'the-pack-addon'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ],
                ],
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .desc' => 'padding-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'hcolr',
            [
                'label' => esc_html__('Heading color', 'the-pack-addon'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .heading' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'hmr',
            [
                'label' => esc_html__('Heading margin', 'the-pack-addon'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'shcolr',
            [
                'label' => esc_html__('Sub heading color', 'the-pack-addon'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sub' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'd_typo',
                'label' => esc_html__('Heading Typo', 'the-pack-addon'),
                'selector' => '{{WRAPPER}} .heading',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sd_typo',
                'label' => esc_html__('Sub Heading Typo', 'the-pack-addon'),
                'selector' => '{{WRAPPER}} .sub',
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'e3',
            [
                'label' => esc_html__('Overlay', 'the-pack-addon'),
            ]
        );

        $this->add_control(
            'ovbg',
            [
                'label' => esc_html__('Background', 'the-pack-addon'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '.tp-pop-response' => 'background: {{VALUE}};',
                ],
            ]
        );
 
        $this->add_control(
            'clbg',
            [
                'label' => esc_html__('Close background', 'the-pack-addon'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '.tp-pop-response .close' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'clclr',
            [
                'label' => esc_html__('Close Color', 'the-pack-addon'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '.tp-pop-response .close' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'clwh',
            [
                'label' => esc_html__('Close Width & height', 'the-pack-addon'),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '.tp-pop-response .close' => 'width:{{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'clfs',
            [
                'label' => esc_html__('Close Font size', 'the-pack-addon'),
                'type' => Controls_Manager::SLIDER,
                'selectors' => [
                    '.tp-pop-response .close' => 'font-size:{{SIZE}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings();
        require dirname(__FILE__) . '/view.php';
    }
}

$widgets_manager->register(new \ThePackAddon\Widgets\thepack_videobgpop());
