<?php
use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Element_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Css_Filter;

if (!defined('ABSPATH')) {
    exit;
}

class The_Pack_Iconbox_Extra_Control
{
    public static function init()
    { 
        add_action('elementor/element/icon-box/section_style_content/after_section_end', [
            __CLASS__,
            'tp_icon_box_extra'
        ], 10, 2);
    }

    public static function tp_icon_box_extra($element, $args)
    {
        $element->start_controls_section(
            'tpbtnsx',
            [
                'label' => esc_html__('Extra style', 'the-pack-addon'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $element->add_control(
            'ibf_pop',
            [
                'label' => esc_html__('Icon before after', 'the-pack-addon'),
                'type' => Controls_Manager::POPOVER_TOGGLE,
                'return_value' => 'yes',
            ]
        );

        $element->add_responsive_control(
            'ibx_h',
            [
                'label' => esc_html__('Min-height', 'the-pack-addon'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-widget-container' => 'min-height: {{SIZE}}{{UNIT}};display: flex;flex-direction: column;justify-content: center;',
                ],
            ]
        );

        $element->start_popover();

        $element->add_responsive_control(
            'ibf_w',
            [
                'label' => esc_html__('Width', 'the-pack-addon'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-widget-container' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $element->add_responsive_control(
            'ibf_h',
            [
                'label' => esc_html__('Height', 'the-pack-addon'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-icon:after' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $element->add_control(
            'ibfbg',
            [
                'label' => esc_html__('Background', 'the-pack-addon'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-icon:after' => 'background: {{VALUE}};',
                ],
            ]
        );

        $element->add_responsive_control(
            'ib_y',
            [
                'label' => esc_html__('Offset Top', 'the-pack-addon'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                    ],
                    '%' => [
                        'min' => -500,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-icon:after' => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $element->add_responsive_control(
            'ib_x',
            [
                'label' => esc_html__('Offset Left', 'the-pack-addon'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                    ],
                    '%' => [
                        'min' => -500,
                        'max' => 500,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 2,
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-icon:after' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $element->add_responsive_control(
            'ib_brd',
            [
                'label' => esc_html__('Border radius', 'the-pack-addon'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['em', 'px' , '%'],
                'selectors' => [
                    '{{WRAPPER}} .elementor-icon:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $element->end_popover();
        
        $element->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .elementor-icon',
                'label' => esc_html__('Box shadow', 'the-pack-addon'),
            ]
        );

        $element->add_control(
            'ibdclr',
            [
                'label' => esc_html__('Icon border color', 'the-pack-addon'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .elementor-icon' => 'border:1px solid {{VALUE}};',
                ],
            ]
        );

        $element->add_responsive_control(
            't-mrg',
            [
                'label' => esc_html__('Title margin', 'the-pack-addon'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['em', 'px'],
                'selectors' => [
                    '{{WRAPPER}} .elementor-icon-box-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $element->add_control(
            'ibdhikl',
            [
                'label' => esc_html__('Hover icon color', 'the-pack-addon'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}:hover .elementor-icon' => 'color:{{VALUE}};',
                ],
            ]
        );

        $element->add_control(
            'ibdhtkl',
            [
                'label' => esc_html__('Hover title color', 'the-pack-addon'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}:hover .elementor-icon-box-title' => 'color:{{VALUE}};',
                ],
            ]
        );

        $element->add_control(
            'ibdhdkl',
            [
                'label' => esc_html__('Hover description color', 'the-pack-addon'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}:hover .elementor-icon-box-description' => 'color:{{VALUE}};',
                ],
            ]
        );
        $element->add_responsive_control(
            'irote',
            [
                'label' => esc_html__('Rotate', 'the-pack-addon'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 360,
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-icon>*' => 'transform: rotate({{SIZE}}deg);',
                ],
            ]
        );

        $element->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'ixbdr',
                'selector' => '{{WRAPPER}} .elementor-icon',
                'fields_options' => [
                    'border' => [
                        'label' => esc_html__('Icon border', 'the-pack-addon'),
                    ]
                ] 
            ]
        );
        $element->add_control(
            'ibfrthv',
            [
                'label' => esc_html__('Rotate on hover', 'the-pack-addon'),
                'type' => Controls_Manager::SWITCHER,
                'selectors' => [
                    '{{WRAPPER}}:hover .elementor-icon' => 'transform: rotateY(180deg);',
                ],
            ]
        );
        $element->add_control(
            'ibgrbh',
            [
                'label' => esc_html__('Enable blur background', 'the-pack-addon'),
                'type' => Controls_Manager::SWITCHER,
                'prefix_class' => 'tp_icon_blur_',
            ]
        );
        $element->add_responsive_control(
            'ibbrdq',
            [
                'label' => esc_html__('Blur border radius', 'the-pack-addon'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 500,
                    ]
                ],
                'condition' => [
                    'ibgrbh' => 'yes',
                ],                
                'selectors' => [ 
                    '{{WRAPPER}} .elementor-icon::after' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        do_action('the_pack_svg_path_color', $element,'ikbudx_','svg path');

        $element->end_controls_section();
    }
}

The_Pack_Iconbox_Extra_Control::init();
