<div class="wrap">
  <div class="flex flex-col items-center justify-center mt-16">
    <div class="relative w-16 h-16">
      <img class="w-full h-full rounded-full object-cover" src="data:img/png;base64,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">
    </div>
    <div class="mt-10 w-full max-w-2xl bg-white shadow-md items-center">
       <div class="p-6 mx-auto">
        <h1 class="font-medium m-auto text-black"><?php echo esc_html( __( 'Welcome to The Events Calendar Shortcode &amp; Block', 'the-events-calendar-shortcode' ) ); ?></h1>
        <p class="text-gray-500 text-base"><?php echo esc_html( __( "Congratulations! You're on your way to promoting your events, anywhere on your site.", 'the-events-calendar-shortcode' ) ); ?></p>
      </div>
      <div class="text-center">
        <iframe width="560" height="315" src="https://www.youtube-nocookie.com/embed/_hpfuoa6MZM?si=g2oKu4mZhHpVOAk1&start=105&showinfo=0&rel=0" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
      </div>
      <div class="p-6 mx-auto">
        <p class="text-gray-500 text-base"><?php echo esc_html( __( 'The Events Calendar Shortcode &amp; Block makes it easy to list your events on your site.', 'the-events-calendar-shortcode' ) ); ?></p>
      </div>
      <div class="flex bg-gray-100 py-6">
        <div class="flex-1">
          <img class="object-cover max-w-full h-auto" src="<?php echo esc_attr( plugins_url( 'static/images/the-events-calendar-block.png', TECS_CORE_PLUGIN_FILE ) ); ?>">
        </div>
        <div class="flex-1 p-6">
          <p class="text-gray-500 text-base"><?php echo esc_html( __( 'When using the WordPress editor, select The Events Calendar Block. After saving, the list of your events will display.', 'the-events-calendar-shortcode' ) ); ?></p>
        </div>
      </div>
      <?php if ( defined( 'ELEMENTOR_VERSION' ) ): ?>
        <div class="flex bg-gray-100 py-6">
          <div class="flex-1 p-6">
            <p class="text-gray-500 text-base"><?php echo esc_html( __( 'When using Elementor, on the left sidebar, find the widget in the "General" section or search for The Events Calendar Shortcode using the search box at the top.', 'the-events-calendar-shortcode' ) ); ?></p>
          </div>
          <div class="flex-1">
            <img class="object-cover max-w-full h-auto" src="<?php echo esc_attr( plugins_url( 'static/images/the-events-calendar-elementor-widget.png', TECS_CORE_PLUGIN_FILE ) ); ?>">
          </div>
        </div>
      <?php endif; ?>
      <div class="p-6">
        <p class="text-gray-500 text-base"><?php echo esc_html( __( 'You can also use a shortcode (which is just some text between [ and ]) on a page to display a list of your events.  For example the shortcode to show next 8 events in the category "festival":', 'the-events-calendar-shortcode' ) ); ?></p>
        <code class="text-sm sm:text-base inline-flex text-left items-center space-x-4 bg-gray-800 text-white rounded-lg p-4 pl-6">[ecs-list-events cat='festival' limit='8']</code>
        <div class="text-center mt-12 mb-8">
          <a href="https://eventcalendarnewsletter.com/getting-started/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started&utm_content=getting-started" target="_blank" class="min-w-[240px] bg-[#EB6924] p-4 flex-none text-white shadow-lg text-center no-underline hover:text-white font-medium text-base"><?php echo esc_html( __( 'Read the Full Guide', 'the-events-calendar-shortcode' ) ); ?></a>
        </div>
      </div>
    </div>
  </div>

  <div class="flex flex-col items-center justify-center mt-4">
    <div class="mt-10 w-full max-w-2xl bg-white shadow-md items-center">
      <div class="p-6 mx-auto">
        <h1><?php echo esc_html( __( 'The Events Calendar Shortcode &amp; Block Features', 'the-events-calendar-shortcode' ) ); ?></h1>
        <p class="text-gray-500 text-base"><?php echo esc_html( __( 'The Events Calendar Shortcode &amp; Block has a lot of helpful features, letting you showcase the events you want to promote on your site.', 'the-events-calendar-shortcode' ) ); ?></p>
      </div>
      <div class="py-3 pr-6">
        <div class="flex flex-row flex-wrap w-full justify-around">
          <div class="w-5/12 mb-2">
            <h2><?php echo esc_html( __( 'Future Events', 'the-events-calendar-shortcode' ) ); ?></h2>
            <p><?php echo esc_html( __( 'Show a list of your upcoming events', 'the-events-calendar-shortcode' ) ); ?></p>
          </div>
          <div class="w-5/12 mb-2">
            <h2><?php echo esc_html( __( 'Past Events', 'the-events-calendar-shortcode' ) ); ?></h2>
            <p><?php echo esc_html( __( 'Show your past events in a listing', 'the-events-calendar-shortcode' ) ); ?></p>
          </div>
          <div class="w-5/12 mb-2">
            <h2><?php echo esc_html( __( 'Category', 'the-events-calendar-shortcode' ) ); ?></h2>
            <p><?php echo esc_html( __( 'Filter events listed by one or more categories', 'the-events-calendar-shortcode' ) ); ?></p>
          </div>
          <div class="w-5/12 mb-2">
            <h2><?php echo esc_html( __( 'Limit', 'the-events-calendar-shortcode' ) ); ?></h2>
            <p><?php echo esc_html( __( 'Choose how many events you want to display', 'the-events-calendar-shortcode' ) ); ?></p>
          </div>
          <div class="w-5/12 mb-2">
            <h2><?php echo esc_html( __( 'Excerpt', 'the-events-calendar-shortcode' ) ); ?></h2>
            <p><?php echo esc_html( __( 'Optionally show an excerpt of your event\'s description', 'the-events-calendar-shortcode' ) ); ?></p>
          </div>
          <div class="w-5/12 mb-2">
            <h2><?php echo esc_html( __( 'Venue', 'the-events-calendar-shortcode' ) ); ?></h2>
            <p><?php echo esc_html( __( 'Optionally show the venue of your events in the listing', 'the-events-calendar-shortcode' ) ); ?></p>
          </div>
          <div class="w-5/12 mb-2">
            <h2><?php echo esc_html( __( 'Thumbnail Image', 'the-events-calendar-shortcode' ) ); ?></h2>
            <p><?php echo esc_html( __( 'Show the thumbnail or featured image for your events', 'the-events-calendar-shortcode' ) ); ?></p>
          </div>
          <div class="w-5/12 mb-2">
            <h2><?php echo esc_html( __( 'Content Ordering', 'the-events-calendar-shortcode' ) ); ?></h2>
            <p><?php echo esc_html( __( 'Choose the order the display the date, thumbnail, venue and excerpt', 'the-events-calendar-shortcode' ) ); ?></p>
          </div>
          <div class="w-5/12 mb-2">
            <h2><?php echo esc_html( __( 'Order', 'the-events-calendar-shortcode' ) ); ?></h2>
            <p><?php echo esc_html( __( 'Choose the order your events are shown, either in ascending or descending order based on date', 'the-events-calendar-shortcode' ) ); ?></p>
          </div>
          <div class="w-5/12 mb-2">
            <h2><?php echo esc_html( __( 'Month', 'the-events-calendar-shortcode' ) ); ?></h2>
            <p><?php echo esc_html( __( 'Only show events for a specific month', 'the-events-calendar-shortcode' ) ); ?></p>
          </div>
          <div class="w-5/12 mb-2">
            <h2><?php echo esc_html( __( 'No Events Message', 'the-events-calendar-shortcode' ) ); ?></h2>
            <p><?php echo esc_html( __( 'Specify what message to show when there are no events', 'the-events-calendar-shortcode' ) ); ?></p>
          </div>
          <div class="w-5/12 mb-2">
            <h2><?php echo esc_html( __( 'View All Events Link', 'the-events-calendar-shortcode' ) ); ?></h2>
            <p><?php echo esc_html( __( 'Show a link to view all your events, underneath your event listing', 'the-events-calendar-shortcode' ) ); ?></p>
          </div>
        </div>
        <div class="text-center my-12">
          <a href="https://eventcalendarnewsletter.com/events-calendar-shortcode-pro-options/?free=1&utm_source=plugin&utm_medium=link&utm_campaign=full-documentation&utm_content=getting-started" target="_blank" class="min-w-[240px] p-4 flex-none shadow-lg text-center no-underline font-medium text-base text-gray-700 bg-gray-100 hover:text-gray-700"><?php echo esc_html( __( 'See All Features', 'the-events-calendar-shortcode' ) ); ?></a>
        </div>
      </div>
      <div class="bg-black text-white w-full text-base">
        <div class="p-6 mx-auto">
          <h2 class="text-white"><?php echo esc_html( __( 'Upgrade to Pro', 'the-events-calendar-shortcode' ) ); ?></h2>
          <div class="flex flex-row">
            <ul class="w-1/3">
              <li class="before:content-['✓'] before:text-[#008a20] before:mr-2"><?php echo esc_html( __( 'Improved default design', 'the-events-calendar-shortcode' ) ); ?></li>
              <li class="before:content-['✓'] before:text-[#008a20] before:mr-2"><?php echo esc_html( __( 'Compact design', 'the-events-calendar-shortcode' ) ); ?></li>
              <li class="before:content-['✓'] before:text-[#008a20] before:mr-2"><?php echo esc_html( __( 'Full calendar design', 'the-events-calendar-shortcode' ) ); ?></li>
              <li class="before:content-['✓'] before:text-[#008a20] before:mr-2"><?php echo esc_html( __( 'Table design', 'the-events-calendar-shortcode' ) ); ?></li>
              <li class="before:content-['✓'] before:text-[#008a20] before:mr-2"><?php echo esc_html( __( 'Grouped design', 'the-events-calendar-shortcode' ) ); ?></li>
              <li class="before:content-['✓'] before:text-[#008a20] before:mr-2"><?php echo esc_html( __( 'Filter bar', 'the-events-calendar-shortcode' ) ); ?></li>
              <li class="before:content-['✓'] before:text-[#008a20] before:mr-2"><?php echo esc_html( __( 'Pagination', 'the-events-calendar-shortcode' ) ); ?></li>
              <li class="before:content-['✓'] before:text-[#008a20] before:mr-2"><?php echo sprintf( esc_html( __( 'Customize using %sShortcode Variables%s', 'the-events-calendar-shortcode' ) ), '<a class="text-white" target="_blank" href="https://demo.eventcalendarnewsletter.com/the-events-calendar-shortcode/custom-design/#variables">', '</a>' ); ?></li>
            </ul>
            <ul class="pl-4 w-1/3">
              <li class="before:content-['✓'] before:text-[#008a20] before:mr-2"><?php echo esc_html( __( 'Button links', 'the-events-calendar-shortcode' ) ); ?></li>
              <li class="before:content-['✓'] before:text-[#008a20] before:mr-2"><?php echo esc_html( __( 'Filter by tag', 'the-events-calendar-shortcode' ) ); ?></li>
              <li class="before:content-['✓'] before:text-[#008a20] before:mr-2"><?php echo esc_html( __( 'Filter by location', 'the-events-calendar-shortcode' ) ); ?></li>
              <li class="before:content-['✓'] before:text-[#008a20] before:mr-2"><?php echo esc_html( __( 'Filter by year', 'the-events-calendar-shortcode' ) ); ?></li>
              <li class="before:content-['✓'] before:text-[#008a20] before:mr-2"><?php echo esc_html( __( 'Offset to skip events', 'the-events-calendar-shortcode' ) ); ?></li>
              <li class="before:content-['✓'] before:text-[#008a20] before:mr-2"><?php echo esc_html( __( 'Add custom designs', 'the-events-calendar-shortcode' ) ); ?></li>
              <li class="before:content-['✓'] before:text-[#008a20] before:mr-2"><?php echo esc_html( __( 'Show a single event', 'the-events-calendar-shortcode' ) ); ?></li>
              <li class="before:content-['✓'] before:text-[#008a20] before:mr-2"><?php echo esc_html( __( 'Customize using Template files', 'the-events-calendar-shortcode' ) ); ?></li>
            </ul>
            <div class="w-3/12 h-auto">
              <div class="flex flex-col w-full h-full align-middle justify-center items-center">
                <div class="p-4 whitespace-nowrap items-center">
                  <a target="_blank" href="https://eventcalendarnewsletter.com/the-events-calendar-shortcode/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started&utm_content=upgrade#pricing" target="_blank" class="bg-[#EB6924] p-4 flex-none text-white shadow-lg text-center no-underline hover:text-white font-medium text-base"><?php echo esc_html( __( 'Upgrade Now', 'the-events-calendar-shortcode' ) ); ?></a>
                </div>
                <div class="p-4 whitespace-nowrap items-center">
                  <a target="_blank" href="https://demo.eventcalendarnewsletter.com/the-events-calendar-shortcode/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started&utm_content=upgrade" class="flex-none no-underline p-4 text-white flex hover:text-white items-center gap-4 text-center"><?php echo esc_html( __( 'View the demo', 'the-events-calendar-shortcode' ) ); ?><svg width="28" height="19" viewBox="0 0 28 19" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M18.0208 0.881354C18.4352 0.466881 19.1072 0.46692 19.5217 0.881441L26.5863 7.94767C27.3671 8.72868 27.3671 9.99476 26.5863 10.7758L19.5217 17.842C19.1072 18.2565 18.4352 18.2566 18.0208 17.8421C17.6063 17.4276 17.6063 16.7556 18.0209 16.3412L23.9422 10.4218H1.06005C0.474599 10.4218 0 9.94717 0 9.36172C0 8.77628 0.474598 8.30168 1.06004 8.30168H23.9422L18.0209 2.38229C17.6063 1.96787 17.6063 1.29584 18.0208 0.881354Z" fill="#94A3B8"></path></svg></a>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="bg-white text-gray-500 w-full text-base">
        <div class="p-6 mx-auto">
          <div class="flex flex-row">
            <div class="w-1/5">
              <div class="relative w-24 h-24 pt-4">
                <img alt="" class="w-full h-full rounded-full object-cover" src="<?php echo esc_attr( plugins_url( 'static/images/barry-harris.png', TECS_CORE_PLUGIN_FILE ) ); ?>">
              </div>
            </div>
            <div class="w-4/5 text-base">
              <div class="mb-4">I was trying to solve issues with multiple The Events Calendar shortcodes on the same page and came across this plugin. After seeing the plugin had a no-questions-asked return policy I decided to give it a try. This plugin addressed my issues, and would highly recommend it to others.</div>
              <div class="mb-2"><strong>Barry Harris</strong>, WordPress/WooCommerce Developer</div>
            </div>
          </div>
        </div>
  </div>

</div>

