<?php
if (! defined('ABSPATH')) exit;
?>
<div class="notice notice-error" style="display: flex;gap:10px">
    <p class="basalam-p">
        در صورتی که از عملکرد پلاگین ووسلام رضایت دارید، لطفا از ما در جعبه ابزار باسلام حمایت کنید.
    </p>
    <button type="button" id="sync_basalam_support_btn" class="button-primary basalam-p">حمایت</button>
</div>

<div id="sync_basalam_support_modal" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.5); z-index:9999; align-items:center; justify-content:center;">
    <div style="background:#fff; padding:30px; border-radius:8px; max-width:500px; width:90%; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
        <h3 style="margin-top:0;font-family: 'PelakFA';">لطفا نظر خود را بنویسید</h3>
        <form method="POST" action="" id="sync_basalam_support_form">
            <?php wp_nonce_field('sync_basalam_support_action', 'sync_basalam_support_nonce'); ?>
            <input type="hidden" name="sync_basalam_support" value="1">
            <textarea name="sync_basalam_comment" id="sync_basalam_comment" rows="5" style="width:100%; padding:10px; border:1px solid #ddd; border-radius:4px; font-family:inherit;font-family: 'PelakFA';" placeholder="نظر خود را اینجا بنویسید..." required></textarea>
            <div style="margin-top:15px; display:flex; gap:10px; justify-content:flex-end;">
                <button type="button" id="sync_basalam_cancel_btn" class="button basalam-p">انصراف</button>
                <button type="submit" class="button-primary basalam-p">ارسال حمایت</button>
            </div>
        </form>
    </div>
</div>

<script>
(function() {
    var modal = document.getElementById('sync_basalam_support_modal');
    var btn = document.getElementById('sync_basalam_support_btn');
    var cancelBtn = document.getElementById('sync_basalam_cancel_btn');

    if (btn) {
        btn.addEventListener('click', function() {
            modal.style.display = 'flex';
        });
    }

    if (cancelBtn) {
        cancelBtn.addEventListener('click', function() {
            modal.style.display = 'none';
        });
    }

    modal.addEventListener('click', function(e) {
        if (e.target === modal) {
            modal.style.display = 'none';
        }
    });
})();
</script>

<?php
$likeservice = new SyncBasalamLike();
if (
    isset($_POST['sync_basalam_support']) && $_POST['sync_basalam_support'] == 1 &&
    isset($_POST['sync_basalam_support_nonce']) &&
    wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['sync_basalam_support_nonce'])), 'sync_basalam_support_action')
) {
    $comment = isset($_POST['sync_basalam_comment']) ? sanitize_textarea_field(wp_unslash($_POST['sync_basalam_comment'])) : 'استفاده کننده فعال پلاگین.';
    $likeservice->like($comment);
}
