<?php
if (! defined('ABSPATH')) exit;
?>
<form action="<?php echo esc_url(admin_url('admin-post.php')); ?>" method="post">
    <input type="hidden" name="action" value="basalam_update_setting">
    <?php wp_nonce_field('basalam_update_setting_nonce', '_wpnonce'); ?>

    <div class="basalam-action-card" style="position: relative;">
        <div class="basalam-info-icon" style="position: absolute;top: 10px;left: 10px;border: 1px solid;border-radius: 70%;width: 22px;height: 22px;">
            <a href="https://www.aparat.com/v/fdcbuj0" target="_blank">
                <img src="<?php echo esc_url(syncBasalamPlugin()->assetsUrl() . "/icons/info-black.svg"); ?>" alt="اطلاعات" style="width: 22px; height: 20px; cursor: pointer;">
            </a>
        </div>
        <h3 class="basalam-h">تنظیمات</h3>
        <p class="basalam-p basalam-p__small">تنظیمات پیشرفته افزونه</p>

        <div class="basalam-form-row">
            <div class="basalam-form-group basalam-p">
                <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('وزن محصولات (گرم)', 'وزن پیش‌فرض که برای محصولات ووکامرس بدون وزن مشخص شده در باسلام نظر گرفته می‌شود. این مقدار در محاسبه هزینه حمل و نقل باسلام مهم است.'); ?>
                <?php SyncBasalamAdminUI::renderDefaultWeight(); ?>
            </div>
            <div class="basalam-form-group basalam-p">
                <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('زمان آماده‌سازی(روز)', 'تعداد روزهایی که برای آماده‌سازی و بسته‌بندی محصولات نیاز دارید. این زمان به مشتریان باسلام نمایش داده می‌شود.'); ?>
                <?php SyncBasalamAdminUI::renderDefaultPreparation(); ?>
            </div>
            <div class="basalam-form-group basalam-p">
                <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('موجودی محصولات', 'موجودی پیش‌فرضی که برای محصولات ووکامرس بدون موجودی مشخص شده در باسلام نظر گرفته می‌شود.'); ?>
                <?php SyncBasalamAdminUI::renderDefaultStockQuantity(); ?>
            </div>
            <div class="basalam-form-group basalam-p">
                <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('جهت رند کردن قیمت در باسلام', 'نحوه رند کردن قیمت‌ها در باسلام. می‌توانید قیمت را به بالا، پایین یا بدون رند تنظیم کنید.'); ?>
                <?php SyncBasalamAdminUI::renderDefaultRound(); ?>
            </div>
        </div>

        <center style="margin-top: 20px;">
            <button type="submit" class="basalam-primary-button basalam-p" style="width:-webkit-fill-available;margin-bottom:0px !important;">
                <span class="dashicons dashicons-saved"></span>
                ذخیره تنظیمات
            </button>
        </center>
</form>

<center style="margin-top: 10px;">
    <button type="button" class="basalam-secondary-button basalam-p" onclick="document.getElementById('basalam-modal').style.display='block';">
        <span class="dashicons dashicons-arrow-down-alt2"></span>
        تنظیمات بیشتر
    </button>
</center>
<div class=" basalam-p" style="display: flex;margin-top: 13px !important;">
    <div style="display: flex; align-items: center; width: 33%;">
        <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('دیباگ', 'حالت دیباگ فقط برای توسعه‌دهندگان توصیه می‌شود.', 'right'); ?>
    </div>
    <?php SyncBasalamAdminUI::renderDeveloperMode(); ?>
</div>
</div>

<div id="basalam-modal" class="basalam-modal">
    <section id="sep-section" class="basalam-action-card" style="background: #fff;margin: 5% auto;padding: 20px;width: 90%;max-width: 800px;max-height: 570px;position: relative;overflow-y: auto;padding-top: 40px;">

        <span onclick="document.getElementById('basalam-modal').style.display='none';" style="position:absolute; top:10px; right:15px; cursor:pointer;">✖️</span>

        <form action="<?php echo esc_url(admin_url('admin-post.php')); ?>" method="post" style="margin-bottom: 20px;">
            <input type="hidden" name="action" value="basalam_update_setting">
            <?php wp_nonce_field('basalam_update_setting_nonce', '_wpnonce'); ?>

            <div class="basalam-form-row">
                <div class="basalam-form-group basalam-p">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('وزن محصولات (گرم)', 'وزن پیش‌فرض که برای محصولات ووکامرس بدون وزن مشخص شده در باسلام نظر گرفته می‌شود. این مقدار در محاسبه هزینه حمل و نقل باسلام مهم است.'); ?>
                    <?php SyncBasalamAdminUI::renderDefaultWeight(); ?>
                </div>
                <div class="basalam-form-group basalam-p">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('وزن بسته بندی (گرم)', 'وزن بسته‌بندی که به وزن محصول اضافه می‌شود و در محاسبه حمل و نقل هزینه ارسال باسلام اهمیت دارد. شامل جعبه، برچسب و سایر مواد بسته‌بندی.'); ?>
                    <?php SyncBasalamAdminUI::renderPackageWeight(); ?>
                </div>
                <div class="basalam-form-group basalam-p">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('زمان آماده‌سازی (روز)', 'تعداد روزهایی که برای آماده‌سازی و بسته‌بندی محصولات نیاز دارید. این زمان به مشتریان باسلام نمایش داده می‌شود.'); ?>
                    <?php SyncBasalamAdminUI::renderDefaultPreparation(); ?>
                </div>
                <div class="basalam-form-group basalam-p">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('افزایش قیمت در باسلام', 'درصد یا مبلغ ثابتی که به قیمت محصولات در باسلام اضافه می‌شود. می‌تواند به صورت درصد(1-100) یا مبلغ ثابت(101-∞) باشد.'); ?>
                    <?php SyncBasalamAdminUI::renderDefaultPercentage(); ?>
                </div>
                <div class="basalam-form-group basalam-p">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('جهت رند کردن قیمت در باسلام', 'نحوه رند کردن قیمت‌ها در باسلام. می‌توانید قیمت را به بالا، پایین یا بدون رند تنظیم کنید.'); ?>
                    <?php SyncBasalamAdminUI::renderDefaultRound(); ?>
                </div>
                <div class="basalam-form-group basalam-p">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('موجودی محصولات', 'موجودی پیش‌فرضی که برای محصولات ووکامرس بدون موجودی مشخص شده در باسلام در نظر گرفته می‌شود.'); ?>
                    <?php SyncBasalamAdminUI::renderDefaultStockQuantity(); ?>
                </div>
                <div class="basalam-form-group basalam-p">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('فیلد های ارسالی هنگام آپدیت محصول', 'انتخاب کنید که هنگام آپدیت محصول چه اطلاعاتی به باسلام ارسال شود. حالت سفارشی امکان انتخاب دقیق اطلاعات را می‌دهد.'); ?>
                    <?php SyncBasalamAdminUI::renderSyncProduct(); ?>
                </div>
                <div class="basalam-form-group basalam-p">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('پیشوند نام محصولات', 'متنی که به ابتدای نام همه محصولات در باسلام اضافه می‌شود. برای مثال: "فروشگاه من -"'); ?>
                    <?php SyncBasalamAdminUI::renderPrefixProductTitle(); ?>
                </div>
                <div class="basalam-form-group basalam-p">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('پسوند نام محصولات', 'متنی که به انتهای نام همه محصولات در باسلام اضافه می‌شود. برای مثال: "- اصل و کیفیت تضمین"'); ?>
                    <?php SyncBasalamAdminUI::renderSuffixProductTitle(); ?>
                </div>
                <div class="basalam-form-group basalam-p">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('پسوند از ویژگی محصول', 'با فعال کردن این گزینه، می‌توانید یکی از ویژگی‌های محصول را به عنوان پسوند به نام محصول اضافه کنید (مثلا نام ناشر کتاب).'); ?>
                    <?php SyncBasalamAdminUI::renderAttributeSuffixEnabled(); ?>
                </div>
                <div class="basalam-form-group basalam-p basalam-attribute-suffix-container" style="display: <?php echo SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::PRODUCT_ATTRIBUTE_SUFFIX_ENABLED) == 'yes' ? 'block' : 'none'; ?>;">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('نام ویژگی برای پسوند', 'نام ویژگی محصول که می‌خواهید به عنوان پسوند به نام محصول اضافه شود.'); ?>
                    <?php SyncBasalamAdminUI::renderAttributeSuffixPriority(); ?>
                </div>
                <div class="basalam-form-group basalam-p">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('محصولات عمده', 'مشخص کنید که آیا همه محصولات به صورت عمده به باسلام ارسال شوند یا اینکه فقط برخی یا هیچ کدام ، از صفحه ویرایش محصول در ووکامرس میتوانید وضعیت عمده محصول را در باسلام مشخص کنید.'); ?>
                    <?php SyncBasalamAdminUI::renderWholesaleProducts(); ?>
                </div>
                <div class="basalam-form-group basalam-p">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('ویژگی ها به توضیحات', 'آیا ویژگی‌های محصول به توضیحات محصول در باسلام اضافه شود یا خیر.'); ?>
                    <?php SyncBasalamAdminUI::renderAttrAddToDesc(); ?>
                </div>
                <div class="basalam-form-group basalam-p">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('توضیحات کوتاه به توضیحات', 'آیا توضیحات کوتاه محصول به توضیحات کامل محصول در باسلام اضافه شود یا خیر.'); ?>
                    <?php SyncBasalamAdminUI::renderShortAttrAddToDesc(); ?>
                </div>
                <div class="basalam-form-group basalam-p">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('وضعیت سفارش های باسلام', ' در صورتی که وضعیت سفارش ، وضعیت های اختصاصی ووسلام باشد امکان مدیریت سفارش(تایید سفارش ، لغو سفارش ، ارسال کد رهگیری و...) از صفحه ویرایش سفارش وجود دارد ، در غیر این صورت سفارشات باسلام با وضعیت پیشفرض ووکارس "در حال انجام" به ووکامرس اضافه میشود.'); ?>
                    <?php SyncBasalamAdminUI::renderOrderStatus(); ?>
                </div>
                <div class="basalam-form-group basalam-p">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('قیمت محصول در باسلام', 'انتخاب کنید که قیمت اصلی یا قیمت حراجی محصول به باسلام ارسال شود ، در صورتی که قیمت حراجی را انتخاب کنید و محصولی قیمت حراجی نداشته باشد قیمت اصلی به باسلام ارسال میشود.'); ?>
                    <?php SyncBasalamAdminUI::renderProductPrice(); ?>
                </div>
                <div class="basalam-form-group basalam-p">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('روش همگام سازی محصولات', 'نحوه بروزرسانی و افزودن محصولات را انتخاب کنید.
                    بهینه (پیشنهادی): عملیات از طریق WP-Cron با کمی تأخیر انجام می‌شود و هیچ تاثیری روی سرعت سایت وارد نمی‌کند.
                    در لحظه: عملیات بلافاصله انجام می‌شود. ممکن است تأثیر لحظه‌ای روی سرعت سایت داشته باشد. اگر از افزونه‌های بهینه‌سازی و سیستم کشینگ استفاده می‌کنید، گزینه در‌لحظه مناسب تر است.'); ?>
                    <?php SyncBasalamAdminUI::renderProductOperationType(); ?>
                </div>
                <div class="basalam-form-group basalam-p">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip(
                        'مدت زمان تخفیف محصول',
                        'در باسلام هر تخفیف بازه زمانی مشخصی دارد. از این بخش می‌توانید مدت اعتبار تخفیف محصولات را تعیین کنید. با هر بار بروزرسانی محصول، این زمان نیز به‌روز خواهد شد.'
                    ); ?>
                    <?php SyncBasalamAdminUI::renderProductDiscountDuration(); ?>
                </div>
                <div class="basalam-form-group basalam-p">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip(
                        'تشخیص خودکار سرعت',
                        'فعال کردن تشخیص خودکار: سیستم بر اساس منابع سرور (رم، CPU، دیسک، شبکه) به طور خودکار بهترین سرعت را تعیین می‌کند. غیرفعال کردن: شما مقدار را دستی تنظیم کنید.'
                    ); ?>
                    <?php SyncBasalamAdminUI::renderTasksPerMinuteAutoToggle(); ?>
                </div>
                <div class="basalam-form-group basalam-p basalam-tasks-manual-container">
                    <?php echo SyncBasalamAdminUI::renderLabelWithTooltip(
                        'تعداد تسک در دقیقه (دستی)',
                        'تعداد تسک‌هایی که در هر دقیقه اجرا می‌شوند. این تنظیم بر سرعت پردازش محصولات و عملیات‌های پس‌زمینه تأثیر می‌گذارد. مقدار بالاتر = سرعت بیشتر (بین 1 تا 60)'
                    ); ?>
                    <?php SyncBasalamAdminUI::renderTasksPerMinute(); ?>
                </div>
                <?php SyncBasalamAdminUI::renderTasksPerMinuteInfo(); ?>
            </div>
            <div id="Basalam-custom-fields" style="display:none; margin-top:15px;margin-bottom: 20px;">
                <label class="basalam-label basalam-p">فیلدهایی که هنگام آپدیت محصول به باسلام ارسال میشوند </label><br>
                <?php SyncBasalamAdminUI::renderSyncProductFields(); ?>
            </div>

            <center>
                <button type="submit" class="basalam-primary-button basalam-p" style="width:-webkit-fill-available;">
                    <span class="dashicons dashicons-saved"></span>
                    ذخیره تنظیمات
                </button>
            </center>
        </form>

        <div class="basalam-form-group basalam-p" style="margin-top: 25px; margin-bottom: 10px !important;">
            <?php echo SyncBasalamAdminUI::renderLabelWithTooltip('تغییر نام ویژگی دسته بندی', 'امکان تعریف مترادف برای ویژگی‌های محصول بین ووکامرس و باسلام ، برای مثال "چاپ کننده" در ووکامرس به "ناشر" در باسلام تبدیل شود.'); ?>
            <?php SyncBasalamAdminUI::renderMapOptionsProduct(); ?>
        </div>
        <div>
            <?php
            global $wpdb;
            $categoryOptionsManager = new SyncBasalamCategoryOptions($wpdb);
            $data = $categoryOptionsManager->getAll();
            SyncBasalamAdminUI::renderCategoryOptionsMapping($data); ?>

        </div>
    </section>
</div>

<script>
(function() {
    'use strict';

    const initialValues = new Map();

    function saveInitialValues(form) {
        const elements = form.querySelectorAll('input, select, textarea');
        elements.forEach(function(element) {
            const name = element.name;
            if (!name || name === 'action' || name === '_wpnonce' || name === '_wp_http_referer') {
                return;
            }

            let value;
            if (element.type === 'checkbox' || element.type === 'radio') {
                value = element.checked;
            } else {
                value = element.value;
            }

            const key = name + '_' + (element.type === 'radio' || element.type === 'checkbox' ? element.value : '');
            initialValues.set(key, value);
        });
    }

    function handleFormSubmit(event) {
        const form = event.target;
        const elements = form.querySelectorAll('input, select, textarea');
        const customFieldsContainer = document.getElementById('Basalam-custom-fields');

        elements.forEach(function(element) {
            const name = element.name;
            if (!name || name === 'action' || name === '_wpnonce' || name === '_wp_http_referer') {
                return;
            }

            // Don't disable elements inside #Basalam-custom-fields
            if (customFieldsContainer && customFieldsContainer.contains(element)) {
                return;
            }

            // Don't disable hidden inputs that are paired with checkboxes
            if (element.type === 'hidden') {
                const checkboxWithSameName = form.querySelector('input[type="checkbox"][name="' + name + '"]');
                if (checkboxWithSameName) {
                    return;
                }
            }

            // IMPORTANT: Don't disable sync_basalam_settings[sync_status_product] as it's dynamically generated
            if (name === 'sync_basalam_settings[sync_status_product]') {
                return;
            }

            // IMPORTANT: Don't disable sync_basalam_settings[sync_status_order] as it's dynamically generated
            if (name === 'sync_basalam_settings[sync_status_order]') {
                return;
            }

            let currentValue;
            if (element.type === 'checkbox' || element.type === 'radio') {
                currentValue = element.checked;
            } else {
                currentValue = element.value;
            }

            const key = name + '_' + (element.type === 'radio' || element.type === 'checkbox' ? element.value : '');
            const initialValue = initialValues.get(key);

            if (initialValue === currentValue) {
                element.disabled = true;
            }
        });

        setTimeout(function() {
            elements.forEach(function(element) {
                element.disabled = false;
            });
        }, 100);
    }

    document.addEventListener('DOMContentLoaded', function() {
        const forms = document.querySelectorAll('form[action*="admin-post.php"]');

        forms.forEach(function(form) {
            const actionInput = form.querySelector('input[name="action"][value="basalam_update_setting"]');
            if (actionInput) {
                saveInitialValues(form);

                form.addEventListener('submit', handleFormSubmit);
            }
        });
    });
})();
</script>