<?php
if (! defined('ABSPATH')) exit;
$sync_basalam_token = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::TOKEN);
$sync_basalam_vendor_id = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::VENDOR_ID);
$logo_filename = 'basalam-logotype.svg';

if (!$sync_basalam_vendor_id && $sync_basalam_token) {
    require_once(syncBasalamPlugin()->templatePath() . "/admin/menu/info/info-not-vendor.php");
    return;
}

if (!$sync_basalam_token) {
    require_once(syncBasalamPlugin()->templatePath() . "/admin/menu/info/info-not-auth.php");
    return;
}

$api_url = "https://core.basalam.com/v3/vendors/$sync_basalam_vendor_id";
$api_service = new SyncBasalamApiServiceManager();
$response = $api_service->sendGetRequest($api_url, [
    'Authorization' => 'Bearer ' . $sync_basalam_token
]);
?>

<div class="wrap">
    <div class="basalam-info-top-section">
        <img src="<?php echo esc_url(syncBasalamPlugin()->assetsUrl() . "/images/" . $logo_filename) ?>" alt="Basalam">
    </div>
    <?php
    require_once(syncBasalamPlugin()->templatePath() . "/admin/menu/info/info-connected.php");
    ?>
</div>