<?php
if (! defined('ABSPATH')) exit;

/**
 * Plugin Name: sync basalam | ووسلام
 * Description: با استفاده از پلاگین ووسلام  میتوایند تمامی محصولات ووکامرس را با یک کلیک به غرفه باسلامی خود اضافه کنید‌، همچنین تمامی سفارش باسلامی شما به سایت شما اضافه میگردد.
 * Version: 1.6.3
 * Author: Woosalam Dev
 * Author URI: https://wp.hamsalam.ir/
 * Plugin URI: https://wp.hamsalam.ir
 * Text Domain: sync-basalam
 * WC requires at least: 8.0.0
 * WC tested up to: 9.9.5
 * Requires Plugins: woocommerce
 * License: GPL-2.0-or-later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

/**
 * Declare plugin compatibility with WooCommerce Custom Order Tables feature.
 *
 * Hooks into the 'before_woocommerce_init' action to let WooCommerce know that
 * this plugin supports the High-Performance Order Storage (HPOS) system.
 *
 * @since 1.0.0
 */

register_activation_hook(__FILE__, 'syncBasalamActivatePlugin');

add_action('before_woocommerce_init', function () {
    if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
    }
});

add_action('init', 'syncBasalamInit');
add_action('admin_init', 'syncBasalamRedirectAfterActivation');

/**
 * Singleton instance of the main plugin class
 */

function syncBasalamPlugin()
{
    static $instance = null;
    if (!$instance) {
        require_once __DIR__ . '/includes/class-sync-basalam-plugin.php';
        $instance = new SyncBasalamPlugin();
    }
    return $instance;
}

/**
 * Initialize the plugin on WordPress init hook
 * Loads main plugin class
 * 
 * @since 1.0.0
 */

function syncBasalamInit()
{
    syncBasalamPlugin();
    syncBasalamNotices();
}

function syncBasalamNotices()
{
    if (!get_option('sync_basalam_like')) {
        add_action('admin_notices', function () {
            $template = syncBasalamPlugin()->templatePath("admin/utilities/like-alert.php");
            require_once $template;
        });
    }

    if (!SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::TOKEN)) {
        add_action('admin_notices', function () {
            $template = syncBasalamPlugin()->templatePath("admin/utilities/access-alert.php");
            require_once($template);
        });
    }
}

/**
 * Redirect to onboarding page after plugin activation
 * 
 * @since 1.0.0
 */
function syncBasalamRedirectAfterActivation()
{
    if (SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::TOKEN)) {
        return;
    }

    if (get_transient('sync_basalam_do_activation_redirect')) {
        delete_transient('sync_basalam_do_activation_redirect');

        if (!isset($_GET['activate-multi'])) {
            wp_safe_redirect(admin_url('admin.php?page=basalam-onboarding'));
            exit;
        }
    }
}

function syncBasalamActivatePlugin()
{
    require_once __DIR__ . '/includes/class-sync-basalam-plugin-activator.php';
    SyncBasalamActivator::activate(
        
    );
    set_transient('sync_basalam_do_activation_redirect', true, 30);
}

require_once plugin_dir_path(__FILE__)  . 'wp-bg-process.php';
require_once plugin_dir_path(__FILE__)  . 'sync-basalam-jobs-runner.php';
require_once plugin_dir_path(__FILE__)  . 'class-sync-basalam-job-manager.php';

SyncBasalamJobManager::getInstance();
new SyncBasalamJobsRunner();
