<?php
if (!defined('ABSPATH')) exit;

class SyncBasalamSimpleProductDiscount implements SyncBasalamDiscountInterface
{
    private $discountService;

    public function __construct(SyncBasalamDiscountManager $discountService)
    {
        $this->discountService = $discountService;
    }

    public function apply(\WC_Product $product): void
    {
        $basalam_id = get_post_meta($product->get_id(), 'sync_basalam_product_id', true);
        if (!$basalam_id) return;

        $regular = $product->get_regular_price();
        $sale = $product->get_sale_price();

        if (!$regular || !$sale) return;

        $discount = $this->discountService->calculateDiscountPercent($regular, $sale);
        $this->discountService->apply($discount, [$basalam_id], null, null);
    }

    public function remove(\WC_Product $product): void
    {
        $basalam_id = get_post_meta($product->get_id(), 'sync_basalam_product_id', true);
        if ($basalam_id) {
            $this->discountService->remove([$basalam_id], null);
        }
    }
}
