<?php
if (! defined('ABSPATH')) exit;
class SyncBasalamUpdateSingleProductService
{
    private $apiservice;

    public function __construct()
    {
        $this->apiservice = new SyncBasalamApiServiceManager;
    }

    public function updateProductInBasalam($productData, $productId)
    {
        $operation = "بروزرسانی محصول باسلام";

        if (!get_post_type($productId) === 'product') {
            throw new \Exception('نوع post محصول نیست.');
        }

        $jsonData = json_encode($productData, JSON_UNESCAPED_UNICODE);
        $token = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::TOKEN);
        $syncBasalamProductId = get_post_meta($productId, 'sync_basalam_product_id', true);
        $url = 'https://core.basalam.com/v4/products/' . $syncBasalamProductId;

        $headers = [
            'Authorization' => 'Bearer ' . $token,
        ];

        $request = $this->apiservice->sendPatchRequest($url, $jsonData, $headers);

        $statusCode = $request['status_code'];

        if ($statusCode != 200) {
            if ($statusCode == 401) {
                $data = [
                    SyncBasalamAdminSettings::TOKEN => '',
                    SyncBasalamAdminSettings::REFRESH_TOKEN => '',
                ];
                SyncBasalamAdminSettings::updateSettings($data);
            } elseif ($statusCode == 403) {
                throw new \Exception("این محصول متعلق به غرفه فعلی نیست.");
            }

            $body = $request['body'] ?? [];

            if (isset($body['messages'][0]['message'])) {
                $message = $body['messages'][0]['message'];
            } elseif (isset($body[0]['message'])) {
                $message = $body[0]['message'];
            } else {
                $message = '';
            }

            if (isset($body['messages'][0]['fields'][0])) {
                $field = $body['messages'][0]['fields'][0];
            } elseif (isset($body[0]['fields'][0])) {
                $field = $body[0]['fields'][0];
            } else {
                $field = '';
            }

            throw new \Exception(esc_html($request['body']['messages'][0]['message']));
        }

        if (is_wp_error($request)) {
            throw new \Exception(esc_html($request['body'][0]['message']));
        }

        $product = wc_get_product($productId);
        if ($product && $product->is_type('variable')) {
            $variations = $product->get_children();

            if (isset($request['body']['variants'])) {
                $wcVariations = [];
                $attributes = $product->get_attributes();

                foreach ($variations as $variationId) {
                    $variation = wc_get_product($variationId);
                    $attributeValues = [];

                    foreach ($attributes as $attributeName => $attribute) {
                        if ($attribute->get_variation()) {
                            $cleanAttributeName = str_replace('attribute_', '', $attributeName);
                            $value = $variation->get_attribute($cleanAttributeName);

                            $value = urldecode($value);
                            $value = trim(mb_strtolower($value, 'UTF-8'));
                            $value = str_replace(['ي', 'ك'], ['ی', 'ک'], $value);

                            if (!empty($value)) {
                                $attributeValues[] = $value;
                            }
                        }
                    }

                    if (!empty($attributeValues)) {
                        $key = implode("_", $attributeValues);
                        $wcVariations[$key] = $variationId;
                    }
                }

                $syncBasalamVariations = [];
                foreach ($request['body']['variants'] as $variant) {
                    $attributeValues = [];
                    if (!empty($variant['properties'])) {
                        foreach ($variant['properties'] as $property) {
                            $val = trim(mb_strtolower($property['value']['value'], 'UTF-8'));
                            $val = str_replace(['ي', 'ك'], ['ی', 'ک'], $val);
                            if (!empty($val)) {
                                $attributeValues[] = $val;
                            }
                        }
                    }

                    if (!empty($attributeValues)) {
                        $key = implode("_", $attributeValues);
                        $syncBasalamVariations[$key] = $variant['id'];
                    }
                }

                foreach ($wcVariations as $key => $wcVarId) {
                    if (isset($syncBasalamVariations[$key])) {
                        update_post_meta($wcVarId, 'sync_basalam_variation_id', $syncBasalamVariations[$key]);
                    }
                }
            }
        }

        update_post_meta($productId, 'sync_basalam_product_sync_status', 'ok');
        SyncBasalamLogger::info("محصول با موفقیت بروزرسانی شد.", ['product_id' => $productId, 'عملیات' => $operation]);

        return [
            'success' => true,
            'message' => 'فرایند به روزرسانی محصول با موفقیت انجام شد.',
            'status_code' => 200
        ];
    }

    public function updateProductStatus($productId, $status)
    {
        $operation = "بروزرسانی وضعیت محصول";
        $token = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::TOKEN);
        $syncBasalamProductId = get_post_meta($productId, 'sync_basalam_product_id', true);
        $url = 'https://core.basalam.com/v4/products/' . $syncBasalamProductId;

        $headers = [
            'Authorization' => 'Bearer ' . $token,
        ];

        $data = ["status" => $status];
        $jsonData = json_encode($data, JSON_UNESCAPED_UNICODE);

        $request = $this->apiservice->sendPatchRequest($url, $jsonData, $headers);

        if (isset($request['status']) && $request['status'] == 401) {
            $data = [
                SyncBasalamAdminSettings::TOKEN => '',
                SyncBasalamAdminSettings::REFRESH_TOKEN => '',
            ];
            SyncBasalamAdminSettings::updateSettings($data);
        }

        if (!is_wp_error($request)) {
            update_post_meta($productId, 'sync_basalam_product_sync_status', 'ok');
            update_post_meta($productId, 'sync_basalam_product_status', $status);
            SyncBasalamLogger::info("وضعیت محصول با موفقیت در باسلام تغییر کرد.", ['product_id' => $productId, 'عملیات' => $operation]);
            return [
                'success' => true,
                'message' => 'وضعیت محصول با موفقیت در باسلام تغییر کرد.',
                'status_code' => 200
            ];
        }
        throw new \Exception("تغییر وضعیت محصول در باسلام ناموفق بود.");
    }
}
