<?php
if (! defined('ABSPATH')) exit;
class SyncBasalamPostAutoConfirmOrder
{
    private $url;
    private $apisevice;
    private $token;
    public function __construct()
    {
        $this->token = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::TOKEN);
        $this->url = SyncBasalamAdminSettings::getStaticSettings("auto_confirm_order_url");
        $this->apisevice = new SyncBasalamApiServiceManager();
    }

    public function postAutoConfirmOrder($isActive = true, $key = 6392)
    {
        $data = json_encode([
            [
                "title" => "تایید خودکار همه سفارش ها",
                "key" => $key,
                "is_active" => $isActive,
                "rules" => null
            ]
        ], JSON_UNESCAPED_UNICODE);

        $header = [
            'Authorization' => 'Bearer ' . $this->token,
        ];
        $response = $this->apisevice->sendPutRequest($this->url, $data, $header);
        var_dump($response);
        if ($response['status_code'] == 200) {
            return [
                'success' => true,
                'message' =>  'تایید خودکار سفارشات با موفقیت فعال شد.',
                'status_code' => $response['status_code'] ?? 200
            ];
        }

        return [
            'success' => false,
            'message' => $response['message'] ?? 'خطایی در فعال سازی تایید خودکار سفارشات رخ داده است.',
            'status_code' => $response['status_code'] ?? 500
        ];
    }
}
