<?php
if (! defined('ABSPATH')) exit;

class SyncBasalamLike
{
    private ?string $token;
    private string $likeUrl;
    private SyncBasalamApiServiceManager $apiService;

    public function __construct()
    {
        $this->token = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::TOKEN);
        $this->likeUrl = SyncBasalamAdminSettings::getStaticSettings('url_like_woo_on_basalam');
        $this->apiService = new SyncBasalamApiServiceManager();
    }

    public function like($comment = null)
    {
        if (empty($comment)) {
            $comment = "استفاده کننده فعال پلاگین.";
        }

        $body = json_encode([
            "comment" => $comment,
            "rating" => 5
        ]);

        $headers = [
            'authorization' => $this->token
        ];

        $response = $this->apiService->sendPostRequest($this->likeUrl, $body, $headers);

        if ($response['status_code'] == 401) {
            $this->renderErrorNotice('لطفا ابتدا دسترسی‌های لازم باسلام را دریافت نمایید.');
            return;
        }
        if ($response['status_code'] == 200) {
            update_option('sync_basalam_like', true);
        }
    }

    private function renderErrorNotice(string $message)
    {
        echo sprintf(
            '<div class="notice notice-error" style="display: flex; gap:10px;">
                <p class="basalam-p">%s</p>
            </div>',
            esc_html($message)
        );
    }
}
