<?php
if (! defined('ABSPATH')) exit;

class SyncBasalamGetSyncBasalamOrders
{
    private $token;
    private $url;
    private $apiservice;

    function __construct()
    {
        $this->token = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::TOKEN);
        $this->url = SyncBasalamAdminSettings::getStaticSettings("url_get_sync_basalam_orders");
        $this->apiservice = new SyncBasalamApiServiceManager();
    }

    public function getWeeklySyncBasalamOrders()
    {
        $oneWeekAgoTimestamp = current_time('timestamp', true) - (7 * 24 * 60 * 60);
        $oneWeekAgoIso = gmdate('c', $oneWeekAgoTimestamp);

        $headers = [
            'Authorization' => 'Bearer ' . $this->token
        ];

        $firstPageUrl = $this->url . '?per_page=30&created_at%5Bgte%5D=' . urlencode($oneWeekAgoIso);

        return $this->fetchAllPages($firstPageUrl, $headers);
    }

    private function fetchAllPages($url, $headers, $collected = [])
    {
        $response = $this->apiservice->sendGetRequest($url, $headers);

        if (!isset($response['data'])) {
            return $collected;
        }

        $collected = array_merge($collected, $response['data']['data']);

        $next = $response['data']['next_cursor'] ?? null;

        if ($next) {
            $nextUrl = $url . '&cursor=' . urlencode($next);
            return $this->fetchAllPages($nextUrl, $headers, $collected);
        }

        return $collected;
    }
}
