<?php
if (! defined('ABSPATH')) exit;

class SyncBasalamFetchUnsyncProducts
{
    private $getSyncBasalamProductsService;
    private $url;
    private $token;

    public function __construct()
    {
        $this->getSyncBasalamProductsService = new SyncBasalamFetchProductsData();
        $this->token = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::TOKEN);
        $this->url = SyncBasalamAdminSettings::getStaticSettings("url_get_all_sync_basalam_products");
    }

    public function getUnsyncBasalamProducts($page)
    {
        $productData = $this->getSyncBasalamProductsService->getSyncBasalamProductData($this->url, $this->token, null, $page);

        if (empty($productData['products'])) {
            return [];
        }

        $products = [];
        foreach ($productData['products'] as $product) {
            if (!get_posts([
                'post_type'   => 'product',
                'meta_key'    => 'sync_basalam_product_id',
                'meta_value'  => $product['id'],
                'fields'      => 'ids'
            ])) {
                $products[] = $product;
            }
        }

        if (empty($products)) {
            return $this->getUnsyncBasalamProducts($page + 1);
        }

        return $products;
    }
}
