<?php
if (! defined('ABSPATH')) exit;

class SyncBasalamFetchProductsData
{
    public function getSyncBasalamProductData($url, $token, $title = null, $page = 1, $perPage = 100)
    {
        $url = $url;
        if ($title) {
            $url .= '?title=' . $title;
        } else {
            $url .= '?page=' . $page;
            $url .= '&per_page=' . $perPage;
        }

        $apiservice = new SyncBasalamApiServiceManager();
        $response = $apiservice->sendGetRequest($url, [
            'Authorization' => 'Bearer ' . $token
        ]);

        if (isset($response['timeout_error']) && $response['timeout_error'] === true) {
            return [
                'timeout_error' => true,
                'total_page' => 1,
                'products' => []
            ];
        }

        $products = [];

        if (isset($response['data']['data'])) {
            foreach ($response['data']['data'] as $product) {
                $products[] = [
                    'id' => $product['id'],
                    'title' => $product['title'],
                    'photo' => $product['photo']['md'],
                    'price' => $product['price']
                ];
            }
        }

        return [
            'total_page' => $response['data']['total_page'] ?? 1,
            'products' => $products
        ];
    }
}
