<?php
if (! defined('ABSPATH')) exit;
class SyncBasalamFetchCommission
{
    static function fetchCategoryCommission($categoryIds)
    {
        $apiservice = new SyncBasalamApiServiceManager;
        $queryParams = [];

        if (isset($categoryIds[0]) && is_numeric($categoryIds[0])) {
            $queryParams[] = "product.category.level1=" . intval($categoryIds[0]);
        }
        if (isset($categoryIds[1]) && is_numeric($categoryIds[1])) {
            $queryParams[] = "product.category.level2=" . intval($categoryIds[1]);
        }
        if (isset($categoryIds[2]) && is_numeric($categoryIds[2])) {
            $queryParams[] = "product.category.level3=" . intval($categoryIds[2]);
        }

        if (empty($queryParams)) {
            return false;
        }

        $url = "https://core.basalam.com/api_v2/commission/get_percent?" . implode("&", $queryParams);

        $syncBasalamToken = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::TOKEN);

        $result = $apiservice->sendGetRequest($url, [
            'Authorization' => 'Bearer ' . $syncBasalamToken
        ]);

        $commissionPercent = $result['data']['commission_data']['commission_percent'];
        $haveMaxAmount = $result['data']['commission_data']['commission_ceil'];

        if ($haveMaxAmount && $haveMaxAmount['type'] && $haveMaxAmount['type'] == 'fix_amount') {
            $maxAmount = $haveMaxAmount['value'];
            return [$commissionPercent, $maxAmount];
        } else {
            return $commissionPercent;
        }
    }
}
