<?php
defined('ABSPATH') || exit;
class SyncBasalamDiscountTaskScheduler
{
    private $taskModel;
    private $queueManager;

    private const PROCESSOR_TASK_NAME = 'SyncBasalamProductDiscountDispatcher';

    public function __construct()
    {
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-discount-task-model.php';
        $this->taskModel = new SyncBasalamDiscountTaskModel();
        $this->queueManager = new SyncBasalamQueueManager(self::PROCESSOR_TASK_NAME);
    }

    public function scheduleDiscountTask($productId, $discountPercent, $activeDays, $variationId = null, $delayMinutes = 0, $action = 'apply')
    {
        $scheduledAt = null;
        if ($delayMinutes > 0) {
            $scheduledAt = date('Y-m-d H:i:s', current_time('timestamp') + ($delayMinutes * 60));
        }

        return $this->taskModel->create([
            'product_id' => $productId,
            'variation_id' => $variationId,
            'discount_percent' => $discountPercent,
            'active_days' => $activeDays,
            'action' => $action,
            'scheduled_at' => $scheduledAt,
            'status' => SyncBasalamDiscountTaskModel::STATUS_PENDING
        ]);
    }

    public function scheduleMultipleDiscountTasks($tasks)
    {
        $results = [];
        foreach ($tasks as $task) {
            $result = $this->scheduleDiscountTask(
                $task['product_id'],
                $task['discount_percent'],
                $task['active_days'],
                isset($task['variation_id']) ? $task['variation_id'] : null,
                isset($task['delay_minutes']) ? $task['delay_minutes'] : 0,
                isset($task['action']) ? $task['action'] : 'apply'
            );
            $results[] = $result;
        }
        return $results;
    }

    public function startProcessor()
    {
        if (!$this->queueManager->hasPendingTasks(self::PROCESSOR_TASK_NAME)) {
            $this->queueManager->scheduleRecurringTask(60);
            return true;
        }
        return false;
    }

    public function stopProcessor()
    {
        $this->queueManager->cancelAllTasksGroup(self::PROCESSOR_TASK_NAME);
    }

    public function getTaskStatistics()
    {
        return [
            'pending' => $this->taskModel->getTasksCountByStatus(SyncBasalamDiscountTaskModel::STATUS_PENDING),
            'processing' => $this->taskModel->getTasksCountByStatus(SyncBasalamDiscountTaskModel::STATUS_PROCESSING),
            'completed' => $this->taskModel->getTasksCountByStatus(SyncBasalamDiscountTaskModel::STATUS_COMPLETED),
            'failed' => $this->taskModel->getTasksCountByStatus(SyncBasalamDiscountTaskModel::STATUS_FAILED),
            'total' => $this->taskModel->getTasksCountByStatus()
        ];
    }

    public function getPendingTasksGrouped()
    {
        return $this->taskModel->getGroupedPendingTasks();
    }
}