<?php
class SyncBasalamDiscountManager
{
    private $apiService;
    private $url;
    private $token;

    public function __construct()
    {
        $this->apiService = new SyncBasalamApiServiceManager();
        $this->token = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::TOKEN);
        $urlTemplate = SyncBasalamAdminSettings::getStaticSettings("discount_price_url");
        $vendorId = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::VENDOR_ID);
        $this->url = str_replace('{vendor_id}', $vendorId ?? '0', $urlTemplate);
    }

    public function apply($discountPercent, $productIds, $variationIds, $activeDays = null)
    {
        if (!$activeDays) {
            $activeDays = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::DISCOUNT_DURATION) ?? 7;
        }

        $data = json_encode([
            'product_filter' => [
                'product_ids'      => $productIds,
                'variation_ids'    => $variationIds,
                'status' => [3568, 2976]
            ],
            'discount_percent' => $discountPercent,
            'active_days'      => $activeDays,
        ]);

        $header = [
            'Authorization' => 'Bearer ' . $this->token,
        ];
        $res = $this->apiService->sendPostRequest($this->url, $data, $header);
        return $res;
    }

    public function remove($productIds, $variationIds)
    {
        $data = json_encode([
            'product_filter' => [
                'product_ids'      => $productIds,
                'variation_ids'    => $variationIds,
            ],
        ]);

        $header = [
            'Authorization' => 'Bearer ' . $this->token,
        ];

        $res = $this->apiService->sendDeleteRequest($this->url, $header, $data);
        return $res;
    }

    public static function calculateDiscountPercent($primaryPrice, $discountedPrice)
    {
        if ($primaryPrice <= 0) {
            return 0;
        }

        $discountPercent = (($primaryPrice - $discountedPrice) / $primaryPrice) * 100;
        return round($discountPercent);
    }
}
