<?php

if (! defined('ABSPATH')) exit;

class SyncBasalamCreateSingleProductService
{
    private $apiservice;
    public function __construct()
    {
        $this->apiservice = new SyncBasalamApiServiceManager;
    }

    public function createProductInBasalam($productData, $productId)
    {
        if (!get_post_type($productId) === 'product') {
            throw new \Exception('نوع post محصول نیست.');
            return false;
        }
        $jsonData = json_encode($productData, JSON_UNESCAPED_UNICODE);

        $vendorId = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::VENDOR_ID);
        $token = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::TOKEN);

        $url = "https://core.basalam.com/v4/vendors/$vendorId/products";

        $headers = [
            'Authorization' => 'Bearer ' . $token,
        ];

        $request = $this->apiservice->sendPostRequest($url, $jsonData, $headers);
        if ($request['status_code'] != 201 && isset($request['status_code'])) {

            if ($request['status_code'] == 401) {
                $data = [
                    SyncBasalamAdminSettings::TOKEN => '',
                    SyncBasalamAdminSettings::REFRESH_TOKEN => '',
                ];
                SyncBasalamAdminSettings::updateSettings($data);
            }

            $message = !empty($request['body']['messages'][0]['message']) ? $request['body']['messages'][0]['message'] : $request['body'][0]['message'];
            $field = !empty($request['body']['messages'][0]['fields'][0]) ? $request['body']['messages'][0]['fields'][0] : $request['body'][0]['fields'][0];

            throw new \Exception('فرایند اضافه کردن محصول ناموفق بود: ' . esc_html($message) . ' :   ' . esc_html($field));
            return false;
        }

        if (is_wp_error($request)) {
            throw new \Exception('درخواست موفقیت آمیز نبود: ' . esc_html($request['body'][0]['message']));
            return false;
        }
        if (isset($request['body']['id'])) {
            if (isset($request['body']['variants'])) {
                $product = wc_get_product($productId);

                if ($product && $product->is_type('variable')) {
                    $wcVariations = [];
                    $attributes = $product->get_attributes();

                    foreach ($product->get_children() as $variationId) {
                        $variation = wc_get_product($variationId);
                        $attributeValues = [];

                        foreach ($attributes as $attributeName => $attribute) {
                            if ($attribute->get_variation()) {
                                $cleanAttributeName = str_replace('attribute_', '', $attributeName);
                                $value = $variation->get_attribute($cleanAttributeName);
                                if (!empty($value)) {
                                    $attributeValues[] = $value;
                                }
                            }
                        }

                        if (!empty($attributeValues)) {
                            $key = implode("_", $attributeValues);
                            $wcVariations[$key] = $variationId;
                        }
                    }

                    $syncBasalamVariations = [];
                    foreach ($request['body']['variants'] as $variant) {
                        $attributeValues = [];
                        if (!empty($variant['properties'])) {
                            foreach ($variant['properties'] as $property) {
                                $attributeValues[] = $property['value']['value'];
                            }
                        }

                        if (!empty($attributeValues)) {
                            $key = implode("_", $attributeValues);
                            $syncBasalamVariations[$key] = $variant['id'];
                        }
                    }

                    $variationMapping = [];
                    foreach ($wcVariations as $key => $wcVarId) {
                        if (isset($syncBasalamVariations[$key])) {
                            $variationMapping[$wcVarId] = $syncBasalamVariations[$key];
                            update_post_meta($wcVarId, 'sync_basalam_variation_id', $syncBasalamVariations[$key]);
                        }
                    }
                }
            }

            update_post_meta($productId, 'sync_basalam_product_id', $request['body']['id']);
            update_post_meta($productId, 'sync_basalam_product_status', 2976);
            update_post_meta($productId, 'sync_basalam_product_sync_status', 'ok');
            SyncBasalamLogger::info("محصول با موفقیت در باسلام ایجاد شد.", ['product_id' => $productId, 'عملیات' => "افزودن محصول جدید در باسلام"]);
            return [
                'success' => true,
                'message' => 'محصول با موفقیت به باسلام اضافه شد.',
                'status_code' => 200
            ];
        }

        throw new \Exception("فرایند اضافه کردن محصول ناموفق بود");
        return false;
    }
}
