<?php
if (! defined('ABSPATH')) exit;

class SyncBasalamAutoConnectProducts
{
    private $token;
    private $url;

    function __construct()
    {
        $this->token = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::TOKEN);
        $this->url = SyncBasalamAdminSettings::getStaticSettings("url_get_all_sync_basalam_products");
    }

    private function normalizeTitle($title)
    {
        $title = SyncBasalamConvertFaNum::convertToEn($title);
        return trim(mb_strtolower($title));
    }

    public function checkSameProduct($title = null, $page = 1)
    {
        try {
            $getSyncBasalamProductData = new SyncBasalamFetchProductsData();
            if ($title) {
                $title = mb_substr($title, 0, 120);
                $syncBasalamProducts = $getSyncBasalamProductData->getSyncBasalamProductData($this->url, $this->token, $title);
            } else {
                $syncBasalamProducts = $getSyncBasalamProductData->getSyncBasalamProductData($this->url, $this->token, null, $page);
            }

            if (isset($syncBasalamProducts['timeout_error']) && $syncBasalamProducts['timeout_error'] === true) {
                return [
                    'timeout_error' => true,
                    'message' => 'درخواست به دلیل timeout ناموفق بود.',
                    'status_code' => 400
                ];
            }

            if ($title) {
                return $syncBasalamProducts['products'];
            }

            global $wpdb;
            $matchedProducts = [];

            foreach ($syncBasalamProducts['products'] as $syncBasalamProduct) {
                $normalizedTitle = $this->normalizeTitle($syncBasalamProduct['title']);

                if (mb_strlen($normalizedTitle) >= 120) {
                    $likeTitle = $normalizedTitle . '%';
                } else {
                    $likeTitle =  $normalizedTitle;
                }

                $productId = $wpdb->get_var(
                    $wpdb->prepare("
                    SELECT p.ID
                    FROM {$wpdb->posts} p
                    LEFT JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id AND pm.meta_key = 'sync_basalam_product_id'
                    WHERE p.post_type = 'product'
                    AND p.post_status = 'publish'
                    AND pm.post_id IS NULL
                    AND LOWER(p.post_title) LIKE LOWER(%s)
                    LIMIT 1
                ", $likeTitle)
                );

                if ($productId) {
                    $connectProductService = new SyncBasalamConnectSingleProductService;
                    $result = $connectProductService->connectProductById($productId, $syncBasalamProduct['id']);

                    $jobManager = new SyncBasalamJobManager();
                    $jobManager->createJob(
                        'SyncBasalamUpdateSingleProduct',
                        'pending',
                        $productId,
                    );

                    if ($result) {
                        SyncBasalamLogger::info($syncBasalamProduct['title'] . ' به محصول مشابه خود در باسلام متصل شد', [
                            'product_id' => $productId,
                            'عملیات' => "اتصال اتوماتیک محصولات ووکامرس و باسلام"
                        ]);
                    }
                    $matchedProducts[] = $syncBasalamProduct;
                }
            }

            if (!empty($syncBasalamProducts['total_page']) && is_numeric($syncBasalamProducts['total_page'])) {
                update_option('sync_basalam_auto_connect_all_pages', $syncBasalamProducts['total_page']);
            } else {
                $current = get_option('sync_basalam_auto_connect_last_page_checked', 1);
                update_option('sync_basalam_auto_connect_all_pages', $current + 10);
            }

            $totalPage = get_option('sync_basalam_auto_connect_all_pages');

            if ($page < $totalPage) {
                return [
                    'success' => true,
                    'message' => 'محصولات با موفقیت به صف اتصال افزوده شدند.',
                    'status_code' => 200
                ];
            } else {
                if (!empty($matchedProducts)) {
                    return [
                        'success' => true,
                        'message' => 'اتصال محصولات کامل شد.',
                        'status_code' => 200
                    ];
                } else {
                    return [
                        'error' => true,
                        'message' => 'محصول مشابهی یافت نشد.',
                        'status_code' => 404
                    ];
                }
            }
        } catch (Exception $e) {
            return [
                'error' => true,
                'message' => $e->getMessage(),
                'status_code' => 400
            ];
        }
    }
}
