<?php
if (! defined('ABSPATH')) exit;

class SyncBasalamDebug extends SyncBasalamQueueAbstract
{
    protected function getHookName()
    {
        return 'sync_basalam_plugin_debug';
    }

    public function handle($args)
    {
        $apiservice = new SyncBasalamApiServiceManager();
        $url = 'https://basalam.com';

        $start = microtime(true);

        $response = $apiservice->sendGetRequest($url, []);

        $elapsedMs = (int) round((microtime(true) - $start) * 1000);

        $success = false;
        $statusCode = null;
        $errorMessage = null;

        if (is_wp_error($response)) {
            $errorMessage = $response['data'];
        } else {
            $statusCode = $response['status_code'];
            $success = $statusCode >= 200 && $statusCode < 400;
        }

        global $wpdb;
        $tableName = $wpdb->prefix . 'sync_basalam_debug_logs';

        $wpdb->insert(
            $tableName,
            [
                'request_url' => $url,
                'status_code' => $statusCode,
                'success' => $success ? 1 : 0,
                'response_time_ms' => $elapsedMs,
                'error_message' => $errorMessage,
                'created_at' => current_time('mysql'),
            ],
            [
                '%s',
                '%d',
                '%d',
                '%d',
                '%s',
                '%s',
            ]
        );
    }

    public function schedule()
    {
        return $this->queueManager->scheduleRecurringTask(60, []);
    }
}
