<?php
if (! defined('ABSPATH')) exit;
class SyncBasalamClearLogFiles extends SyncBasalamQueueAbstract
{
    protected function getHookName()
    {
        return 'sync_basalam_plugin_clear_log_files';
    }

    public function handle($args)
    {
        $uploadDir = wp_upload_dir();
        $logDir = trailingslashit($uploadDir['basedir']) . 'wc-logs/';

        if (is_dir($logDir)) {
            $files = glob($logDir . '/basalam-sync-plugin-*.log');

            if ($files) {
                $now = time();
                $daysAgo = 1 * 24 * 60 * 60;

                foreach ($files as $file) {
                    if ($now - filemtime($file) >= $daysAgo) {
                        wp_delete_file($file);
                    }
                }
            }
        }
    }

    public function schedule($data, $delay = null)
    {
        if ($delay == null) {
            if ($this->getLastRunTimestamp() > time()) {
                $delay = $this->getLastRunTimestamp() - time() + 60;
            } else {
                $delay = 60;
            }
        }

        return $this->queueManager->scheduleRecurringTask(604800);
    }
}
