<?php

if (! defined('ABSPATH')) exit;

class SyncBasalamBulkUpdateProducts extends AsyncBackgroundProcess
{
    protected $action = 'sync_basalam_bulk_update_products_task';
    protected $batch_size = 1;
    protected function task($offset)
    {
        SyncBasalamLogger::alert('شروع بروزرسانی دسته‌ای محصولات از آفست: ' . $offset);
        $productGetDataService = new SyncBasalamCreateProductDataV2();

        $apiservice = new SyncBasalamApiServiceManager();
        $url = SyncBasalamAdminSettings::getStaticSettings("update_bulk_products_url");
        $token = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::TOKEN);
        $postsPerPage = 50;
        update_option('last_offset_update_products', $offset + $postsPerPage);

        $batchData = [
            'posts_per_page' => $postsPerPage,
            'offset'         => $offset,
        ];

        $productIds = SyncBasalamProductService::getUpdatableProducts($batchData);

        if (!$productIds) {
            delete_option('last_offset_update_products');
            SyncBasalamLogger::info('بروزرسانی دسته‌ای: همه محصولات بروزرسانی شدند.');
            return false;
        }

        $productsData = [];
        foreach ($productIds as $productId) {
            $productData = $productGetDataService->getProductData($productId);
            if (!empty($productData)) {
                $productsData[] = $productData;
            }
        }
        $data = json_encode([
            'data' => $productsData
        ]);

        $header = [
            'Authorization' => 'Bearer ' .  $token,
        ];

        $res = $apiservice->sendPatchRequest($url, $data, $header);
        if ($res['status_code'] == 202) {
            SyncBasalamLogger::info('بروزرسانی دسته جمعی محصولات با موفقیت انجام شد.');
        } else {
            SyncBasalamLogger::error('خطا در بروزرسانی دسته جمعی محصولات: ' . json_encode($res, JSON_UNESCAPED_UNICODE));
        }
        return false;
    }

    protected function complete()
    {
        parent::complete();

        $offset = get_option('last_offset_update_products');

        if ($offset) {
            $jobManager = new SyncBasalamJobManager();

            $pendingCount = $jobManager->getCountJobs(array(
                'job_type' => 'sync_basalam_bulk_update_products',
                'status' => 'pending'
            ));

            if ($pendingCount === 0) {
                $jobManager->createJob(
                    'sync_basalam_bulk_update_products',
                    'pending',
                    $offset,
                );
            }
        }
    }
}
