<?php

if (! defined('ABSPATH')) exit;

class SyncBasalamProductsConnectDispatcher extends AsyncBackgroundProcess
{
    protected $action = 'sync_basalam_auto_connect_products_task';
    protected $batch_size = 1;
    protected function task($item)
    {
        $page = is_numeric($item) ? (int)$item : 1;

        $basalamChecker = new SyncBasalamAutoConnectProducts();
        $result = $basalamChecker->checkSameProduct(null, $page);

        if (isset($result['timeout_error']) && $result['timeout_error'] === true) {
            SyncBasalamLogger::debug("صفحه $page به دلیل timeout رد شد و صفحه بعدی برای اتصال محصولات بررسی میشود.");
        }

        return false;
    }

    protected function complete()
    {
        parent::complete();

        $current = get_option('sync_basalam_auto_connect_last_page_checked', 1);

        $next = $current + 1;

        if (get_option('sync_basalam_auto_connect_all_pages') > $current && get_option('sync_basalam_cancel_auto_connect_task') != 1) {
            update_option('sync_basalam_auto_connect_last_page_checked', $next);

            $this->push($next);
            $this->save()->dispatch();
        } else {
            delete_option('sync_basalam_auto_connect_last_page_checked');
            delete_option('sync_basalam_auto_connect_all_pages');
            delete_option('sync_basalam_cancel_auto_connect_task');
        }
    }
}
