<?php
if (! defined('ABSPATH')) exit;
class SyncBasalamQueueManager
{
    private const GROUP_NAME = 'sync-basalam';

    public $taskName;

    public function __construct($taskName)
    {
        $this->taskName = $taskName;
    }

    public function scheduleSingleTask($args = [], $delay = 0)
    {
        $timestamp = time() + $delay;

        $this->setLastRunTimestamp($timestamp);

        return WC()->queue()->schedule_single(
            $timestamp,
            $this->taskName,
            [$args],
            self::GROUP_NAME
        );
    }

    public function scheduleRecurringTask($intervalInSeconds, $args = [])
    {
        $startTimestamp = time();

        $this->setLastRunTimestamp($startTimestamp);

        return WC()->queue()->schedule_recurring(
            $startTimestamp,
            $intervalInSeconds,
            $this->taskName,
            [$args],
            self::GROUP_NAME
        );
    }

    protected function setLastRunTimestamp($timestamp)
    {
        return update_option($this->taskName . '_last_run', $timestamp);
    }

    public static function hasPendingTasks($taskName)
    {
        // Search for pending tasks in queue
        $pendingTasks = WC()->queue()->search([
            'hook' => $taskName,
            'status' => 'pending'
        ]);

        return !empty($pendingTasks);
    }

    public static function cancelAllTasksGroup($taskName)
    {
        WC()->queue()->cancel_all($taskName);

        delete_option($taskName . '_last_run');
    }

    /**
     * Count number of pending tasks for given task name
     * Used for queue monitoring and performance optimization
     *
     * @param string $taskName Name of the tasks to count
     * @return int Number of pending tasks
     * @since 1.0.0
     */
    public static function countOfPendingTasks($taskName)
    {
        // Search for pending tasks with high limit
        $pendingTasks = WC()->queue()->search([
            'hook' => $taskName,
            'status' => 'pending',
            'per_page' => 5000 // High limit to get all pending tasks
        ]);

        return count($pendingTasks);
    }
}