<?php
if (! defined('ABSPATH')) exit;
abstract class SyncBasalamQueueAbstract
{
    protected $queueManager;

    public function __construct()
    {
        $this->queueManager = new SyncBasalamQueueManager($this->getHookName());
    }

    public function registerHooks()
    {
        add_action($this->getHookName(), [$this, 'handle'], 10, 1);
    }

    protected function getLastRunTimestamp()
    {
        return intval(get_option($this->getHookName() . '_last_run', time()));
    }

    abstract public function handle($args);

    abstract protected function getHookName();
}
