<?php
if (! defined('ABSPATH')) exit;

class SyncBasalamUpdateWooProduct extends SyncBasalamProductListener implements SyncBasalamListenerInterface
{
    use SyncBasalamProductStatusTrait;

    public function handle($productId)
    {

        if (!$this->isAvailableProduct($productId) || !$this->isProductSyncEnabled()) {
            return;
        }

        $operationType = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::PRODUCT_OPERATION_TYPE);

        $jobsRunner = new SyncBasalamJobsRunner;
        if (!$jobsRunner->hasProductJobInProgress($productId, 'sync_basalam_update_single_product')) {

            if ($operationType === 'immediate') {
                $this->executeImmediateUpdate($productId);
            } else {
                $jobManager = new SyncBasalamJobManager();
                $jobManager->createJob(
                    'sync_basalam_update_single_product',
                    'pending',
                    $productId,
                );
            }
        }
    }

    private function executeImmediateUpdate($productId)
    {
        update_post_meta($productId, 'sync_basalam_product_sync_status', 'pending');

        $productOperations = new SyncBasalamAdminProductOperations();
        $result = $productOperations->updateExistProduct($productId, null);

        if ($result['success']) {
            update_post_meta($productId, 'sync_basalam_product_sync_status', 'ok');
        } else {
            update_post_meta($productId, 'sync_basalam_product_sync_status', 'no');
        }
    }

    private function isAvailableProduct($productId)
    {
        $product = wc_get_product($productId);
        $syncBasalamProductId = get_post_meta($productId, 'sync_basalam_product_id', true);

        if (!$product || $product->is_type('variation') || !$syncBasalamProductId) {
            return false;
        }
        return true;
    }
}
