<?php
if (! defined('ABSPATH')) exit;
class SyncBasalamRestoreProductListener extends SyncBasalamProductListener implements SyncBasalamListenerInterface
{
    use SyncBasalamProductStatusTrait;
    public function handle($productId)
    {
        $product = wc_get_product($productId);

        if (!$product || $product->is_type('variation')) {
            return;
        }

        $syncStatus = $this->isProductSyncEnabled();

        if (!$syncStatus || !wc_get_product($productId)) {
            return;
        }

        $productOperations = new SyncBasalamAdminProductOperations();
        $productOperations->restoreExistProduct($productId);
    }
}
