<?php
if (! defined('ABSPATH')) exit;

class SyncBasalamCreateWooProduct extends SyncBasalamProductListener implements SyncBasalamListenerInterface
{
    use SyncBasalamProductStatusTrait;

    public function handle($productId)
    {

        if (!$this->isAvailableProduct($productId)) {
            return;
        }

        $operationType = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::PRODUCT_OPERATION_TYPE);
        $jobsRunner = new SyncBasalamJobsRunner;

        if (!$jobsRunner->hasProductJobInProgress($productId, 'sync_basalam_create_single_product')) {

            if ($operationType === 'immediate') {
                $this->executeImmediateCreate($productId);
            } else {
                $jobManager = new SyncBasalamJobManager();
                $jobManager->createJob(
                    'sync_basalam_create_single_product',
                    'pending',
                    $productId,
                );
            }
        }
    }

    private function executeImmediateCreate($productId)
    {

        update_post_meta($productId, 'sync_basalam_product_sync_status', 'pending');

        $productOperations = new SyncBasalamAdminProductOperations();
        $result = $productOperations->createNewProduct($productId, []);

        if ($result['success']) {
            update_post_meta($productId, 'sync_basalam_product_sync_status', 'ok');
        } else {
            update_post_meta($productId, 'sync_basalam_product_sync_status', 'no');
        }
    }

    private function isAvailableProduct($productId)
    {
        $product = wc_get_product($productId);
        $postType = get_post_type($productId);
        $postStatus = get_post_status($productId);
        $syncStatus = $this->isProductSyncEnabled();
        $syncBasalamProductId = get_post_meta($productId, 'sync_basalam_product_id', true);

        if (!$product || $product->is_type('variation') || $postType !== 'product' || !$syncStatus || $syncBasalamProductId || $postStatus !== 'publish') {
            return false;
        }

        return true;
    }
}
