<?php
if (! defined('ABSPATH')) exit;
class SyncBasalamMigrationManager
{
    private $migrations = [];

    public function __construct()
    {
        $this->migrations = [
            '1.3.0' => new SyncBasalamMigration_1_3_0(),
            '1.3.2' => new SyncBasalamMigration_1_3_2(),
            '1.3.8' => new SyncBasalamMigration_1_3_8(),
            '1.3.9' => new SyncBasalamMigration_1_3_9(),
            '1.4.0' => new SyncBasalamMigration_1_4_0(),
            '1.4.1' => new SyncBasalamMigration_1_4_1(),
            '1.5.4' => new SyncBasalamMigration_1_5_4(),
            '1.6.2' => new SyncBasalamMigration_1_6_2(),
        ];
    }

    public function runMigrations($currentVersion, $newVersion)
    {
        foreach ($this->migrations as $version => $migration) {
            if (version_compare($currentVersion, $version, '<')) {
                $migration->up();
            }
        }

        update_option('sync_basalam_version', $newVersion);
    }
}
