<?php
if (! defined('ABSPATH')) exit;

class SyncBasalamGetCategoryAttributes extends SyncBasalamActionController
{
    public function __invoke()
    {
        if (isset($_POST['catID'])) {
            $catId = sanitize_text_field(wp_unslash($_POST['catID']));
        } else {
            return false;
        }

        $categoryAttrs = SyncBasalamGetCategoryAttr::getAttr($catId);

        if ($categoryAttrs['data']) {
            wp_send_json_success([
                [
                    'attributes' => $categoryAttrs['data']
                ]
            ]);
        } else {
            wp_send_json_success([
                [
                    'attributes' => []
                ]
            ]);
        }
    }
}
