<?php
if (! defined('ABSPATH')) exit;

class SyncBasalamDetectionProductCategories extends SyncBasalamActionController
{
    public function __invoke()
    {
        if (!isset($_POST['productTitle'])) {
            wp_send_json_error(['message' => 'عنوان محصول ارسال نشده است.'], 400);
        }

        $productTitle = mb_substr(sanitize_text_field(wp_unslash($_POST['productTitle'])), 0, 120);
        $categoryIds = SyncBasalamGetCategoryId::getCategoryIdFromBasalam($productTitle, 'all');

        if ($categoryIds && is_array($categoryIds)) {
            $categories = array_map(function ($category) {
                return [
                    'cat_id' => $category['cat_id'],
                    'cat_title' => $category['cat_title']
                ];
            }, $categoryIds);

            wp_send_json_success($categories);
        }
    }
}
