<?php
if (! defined('ABSPATH')) exit;

class SyncBasalamCreateSingleProduct extends SyncBasalamActionController
{
    public function __invoke()
    {
        $productOperations = new SyncBasalamAdminProductOperations();

        $productId = isset($_POST['product_id']) ? sanitize_text_field(wp_unslash($_POST['product_id'])) : null;

        $catId = isset($_POST['cat_id']) ? sanitize_text_field(wp_unslash($_POST['cat_id'])) : '';

        $catId = !empty($catId) ? explode(',', $catId) : [];

        if ($productId) {
            $result = $productOperations->createNewProduct($productId, $catId);
        }
        if (!$result['success']) {
            wp_send_json_error(['message' => $result['message']], $result['status_code'] ?? 500);
        }

        wp_send_json_success(['message' => $result['message']], $result['status_code'] ?? 200);
    }
}
