<?php
if (! defined('ABSPATH')) exit;

class SyncBasalamClearLogs extends SyncBasalamActionController
{
    public function __invoke()
    {
        if (!current_user_can('manage_options')) {
            wp_send_json_error([
                'message' => 'شما دسترسی لازم برای این عملیات را ندارید.'
            ], 403);
        }

        $uploadDir = wp_upload_dir();
        $logDir = trailingslashit($uploadDir['basedir']) . 'wc-logs/';

        if (!is_dir($logDir)) {
            wp_send_json_error([
                'message' => 'پوشه لاگ‌ها یافت نشد.'
            ], 404);
        }

        $files = glob($logDir . 'basalam-sync-plugin*.log');
        $deletedCount = 0;

        if ($files) {
            foreach ($files as $file) {
                if (wp_delete_file($file)) {
                    $deletedCount++;
                }
            }
        }

        if ($deletedCount > 0) {
            wp_send_json_success([
                'message' => sprintf('%d فایل لاگ با موفقیت حذف شد.', $deletedCount)
            ]);
        } else {
            wp_send_json_error([
                'message' => 'هیچ فایل لاگی برای حذف یافت نشد.'
            ], 404);
        }
    }
} 