<?php
if (! defined('ABSPATH')) exit;

class SyncBasalamCancelUpdateProducts extends SyncBasalamActionController
{
    public function __invoke()
    {
        $jobManager = new SyncBasalamJobManager();

        $jobTypes = [
            'sync_basalam_bulk_update_products',
            'sync_basalam_update_all_products',
            'sync_basalam_update_single_product'
        ];

        $deletedCount = 0;
        foreach ($jobTypes as $jobType) {
            $result = $jobManager->deleteJob([
                'job_type' => $jobType,
                'status' => 'pending'
            ]);
            if ($result) {
                $deletedCount += $result;
            }

            $result = $jobManager->deleteJob([
                'job_type' => $jobType,
                'status' => 'processing'
            ]);
            if ($result) {
                $deletedCount += $result;
            }
        }

        delete_option('last_offset_update_products');
        delete_option('last_offset_full_update_products');
        delete_option('last_offset_update_products_new');
        delete_option('sync_basalam_last_updatable_product_id');


        (new SyncBasalamBulkUpdateProducts())->cancel();
        (new SyncBasalamUpdateProduct())->cancel();

        $this->deleteAllBatches();

        $this->clearAllLocks();
    }

    private function deleteAllBatches()
    {
        global $wpdb;

        $patterns = [
            'sync_basalam_bulk_update_products_task_%_batch_%',
            'SyncBasalamUpdateSingleProduct_%_batch_%',
            'sync_basalam_%_batch_%'
        ];

        foreach ($patterns as $pattern) {
            $wpdb->query(
                $wpdb->prepare(
                    "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s",
                    $pattern
                )
            );
        }
    }

    private function clearAllLocks()
    {
        global $wpdb;

        $patterns = [
            '_transient_sync_basalam_bulk_update_products_task_%_lock',
            '_transient_SyncBasalamUpdateSingleProduct_%_lock',
            '_transient_sync_basalam_%_lock'
        ];

        foreach ($patterns as $pattern) {
            $wpdb->query(
                $wpdb->prepare(
                    "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s",
                    $pattern
                )
            );
        }
    }
}
