<?php
if (! defined('ABSPATH')) exit;
class SyncBasalamRemoveMapOption extends SyncBasalamActionController
{
    public function __invoke()
    {
        $wooName = isset($_POST['woo_name']) ? sanitize_text_field(wp_unslash($_POST['woo_name'])) : null;

        $syncBasalamName = isset($_POST['basalam_name']) ? sanitize_text_field(wp_unslash($_POST['basalam_name'])) : null;

        if (!$wooName || !$syncBasalamName) {
            wp_send_json_error([
                'message' => 'اطلاعات ناقص ارسال شده.'
            ], 400);
        }

        global $wpdb;
        $categoryOptionsManager = new SyncBasalamCategoryOptions($wpdb);

        $result = $categoryOptionsManager->delete($wooName, $syncBasalamName);

        if (!$result['success']) {
            wp_send_json_error(['message' => $result['message']], $result['status_code'] ?? 500);
        }

        wp_send_json_success(['message' => $result['message']], $result['status_code'] ?? 200);
    }
}
