<?php
defined('ABSPATH') || exit;

class SyncBasalamPlugin
{
    const VERSION = '1.6.3';

    public function __construct()
    {
        $this->defineConstants();
        $this->migrate();
        $this->includes();
        $this->initTasks();
        $this->initHooks();
        $this->initListener();
        $this->initWpBgProcess();
    }

    private function defineConstants()
    {
        if (!defined('SYNC_BASALAM_PLUGIN_DIR')) {
            define('SYNC_BASALAM_PLUGIN_DIR', str_replace("includes", "", plugin_dir_path(__FILE__)));
        }

        if (!defined('SYNC_BASALAM_PLUGIN_INCLUDES_DIR')) {
            define('SYNC_BASALAM_PLUGIN_INCLUDES_DIR', plugin_dir_path(__FILE__));
        }

        if (!defined('SYNC_BASALAM_PLUGIN_VERSION')) {
            define('SYNC_BASALAM_PLUGIN_VERSION', self::VERSION);
        }
    }

    private function migrate()
    {
        require_once __DIR__ . '/class-sync-basalam-plugin-activator.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'migration/class-sync-basalam-migration-interface.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'migration/class-sync-basalam-migration-V-1-3-0.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'migration/class-sync-basalam-migration-V-1-3-2.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'migration/class-sync-basalam-migration-V-1-3-8.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'migration/class-sync-basalam-migration-V-1-3-9.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'migration/class-sync-basalam-migration-V-1-4-0.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'migration/class-sync-basalam-migration-V-1-4-1.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'migration/class-sync-basalam-migration-V-1-5-4.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'migration/class-sync-basalam-migration-V-1-6-2.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'migration/class-sync-basalam-migration-manager.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'migration/class-sync-basalam-migrator-service.php';

        $currentVersion = get_option('sync_basalam_version') ?: '0.0.0';
        $manager = new SyncBasalamMigrationManager();
        $manager->runMigrations($currentVersion, self::VERSION);
    }

    private function includes()
    {

        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'logger/interface-sync-basalam-logger-interface.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'logger/class-sync-basalam-wp-logger.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'logger/class-sync-basalam-woo-logger.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'logger/class-sync-basalam-logger.php';

        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'utilities/class-sync-basalam-text-converter.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'utilities/class-sync-basalam-convert-fa-num.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'utilities/class-sync-basalam-get-provinces-data.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'utilities/class-sync-basalam-order-manager.php';

        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'productListeners/trait-sync-basalam-check-product-status.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'productListeners/class-sync-basalam-listener.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'productListeners/interface-sync-basalam-listener-interface.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'productListeners/class-sync-basalam-update-product-listener.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'productListeners/class-sync-basalam-create-product-listener.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'productListeners/class-sync-basalam-restore-product-listener.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'productListeners/class-sync-basalam-archive-product-listener.php';

        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'queue/class-sync-basalam-queue-manager.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'queue/class-sync-basalam-queue-abstract.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/class-sync-basalam-product-service.php';

        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-api-service-manager.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-date-converter.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-system-resource-monitor.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-create-product-service.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-update-product-service.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-get-category-id.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-file-uploader.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-fetch-commission.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-order-manager.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-fetch-products-data.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-fetch-unsync-products.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-get-category-attr.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-auto-connect-products.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-like.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-get-basalam-orders.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-fetch-weekly-unsync-orders.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-post-auto-confirm-order.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-connect-product-service.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-discount-manager.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-discount-task-processor.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-discount-task-scheduler.php';

        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-discount-task-model.php';

        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-webhook-service.php';

        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/orders/class-sync-basalam-confirm-order.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/orders/class-sync-basalam-cancel-order.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/orders/class-sync-basalam-cancel-req-order.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/orders/class-sync-basalam-tracking-code-order.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/orders/class-sync-basalam-delay-req-order.php';

        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/discount/class-sync-basalam-discount-interface.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/discount/class-sync-basalam-product-discount-handler.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/discount/class-sync-basalam-simple-product-discount.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/discount/class-sync-basalam-variable-product-discount.php';

        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/pages/SyncBasalamAdminPageInterface.php';

        // Pages
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/pages/SyncBasalamMainPage.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/pages/SyncBasalamLogsPage.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/pages/SyncBasalamInfoPage.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/pages/SyncBasalamHelpPage.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/pages/SyncBasalamCategoryMappingPage.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/pages/SyncBasalamUnsyncedProductsPage.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/pages/SyncBasalamOnboardingPage.php';

        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/class-sync-basalam-menus.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/class-sync-basalam-category-options.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/product/class-sync-basalam-product-status-column.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/product/class-sync-basalam-product-filter.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/product/class-sync-basalam-bulk-product-actions.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/class-sync-basalam-onboarding-manager.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/class-sync-basalam-admin-ui.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/class-sync-basalam-admin-settings.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/class-sync-basalam-faq.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/class-sync-basalam-category-mapping.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/product/class-sync-basalam-mobile-product-fields.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/product/class-sync-basalam-product-type-fields.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/product/class-sync-basalam-get-product-data.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/product/class-sync-basalam-create-product-data-v2.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/product/class-sync-basalam-admin-product-operations.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/product/class-sync-basalam-product-meta-box.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/product/class-sync-basalam-product-wholesale-field.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/order/class-sync-basalam-order-column.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/order/class-sync-basalam-order-meta-box.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/order/class-sync-basalam-order-statuses.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'admin/order/class-sync-basalam-check-orders-button.php';
        require_once $this->templatePath("admin/utilities/connect-ajax-single-product-page.php");

        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'class-sync-basalam-order-endpoint.php';
        require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'class-sync-basalam-route-action.php';
    }

    private function initHooks()
    {
        add_action('admin_menu', array('SyncBasalamMenus', 'registerMenus'));

        add_action('rest_api_init', array('SyncBasalamOrderEndpoint', 'registerRoutes'));

        add_action('admin_enqueue_scripts', array($this, 'adminEnqueueStyles'));
        add_action('admin_enqueue_scripts', array($this, 'adminEnqueueScripts'));

        add_filter('manage_edit-product_columns', array('SyncBasalamProductStatusColumn', 'registerStatusColumn'));
        add_action('manage_product_posts_custom_column', array('SyncBasalamProductStatusColumn', 'renderStatusColumnContent'), 10, 2);

        add_action('add_meta_boxes_product', array('SyncBasalamProductMetaBox', 'registerMetaBox'));

        add_action('woocommerce_product_options_inventory_product_data', array('SyncBasalamMobileProductFields', 'renderCheckbox'));
        add_action('woocommerce_product_options_inventory_product_data', array('SyncBasalamMobileProductFields', 'renderCheckbox'));
        add_action('woocommerce_process_product_meta', array('SyncBasalamMobileProductFields', 'saveCheckbox'));

        add_action('woocommerce_product_options_inventory_product_data', array('SyncBasalamProductTypeFields', 'renderCheckbox'));

        add_action('woocommerce_product_options_inventory_product_data', array('SyncBasalamProductWholesaleField', 'renderCheckbox'));
        add_action('woocommerce_process_product_meta', array('SyncBasalamProductWholesaleField', 'saveCheckbox'));

        add_action('woocommerce_process_product_meta', array('SyncBasalamProductTypeFields', 'saveCheckbox'));

        add_action('manage_woocommerce_page_wc-orders_custom_column', array('SyncBasalamOrderColumn', 'renderColumn'), 10, 2);
        add_filter('manage_woocommerce_page_wc-orders_columns', array('SyncBasalamOrderColumn', 'addColumn'));

        add_action('init', [new SyncBasalamOrderStatuses(), 'registerOrderStatuses'], 20);
        add_filter('wc_order_statuses', [new SyncBasalamOrderStatuses(), 'orderStatuses']);

        add_action('woocommerce_order_status_bslm-rejected', 'wc_maybe_increase_stock_levels');
        add_action('woocommerce_order_status_bslm-preparation', 'wc_maybe_reduce_stock_levels');
        add_action('woocommerce_order_status_bslm-shipping', 'wc_maybe_reduce_stock_levels');
        add_action('woocommerce_order_status_bslm-completed', 'wc_maybe_reduce_stock_levels');

        add_action('sync_basalam_process_discount_tasks', array($this, 'processDiscountTasksCron'));

        add_action('wp_ajax_basalam_search_products', 'Sync_basalam_handle_search_products_ajax');

        add_filter('bulk_actions-edit-product', [SyncBasalamBulkProductActions::getInstance(), 'registerBulkActions']);
        add_filter('handle_bulk_actions-edit-product', [SyncBasalamBulkProductActions::getInstance(), 'handleBulkAction'], 10, 3);

        add_action('woocommerce_duplicate_product', function ($newProductId, $oldProduct) {
            if (!is_object($oldProduct) || $oldProduct->post_type !== 'product') {
                return;
            }
            SyncBasalamAdminProductOperations::disconnectProduct($newProductId);
        }, 10, 2);

        add_action('woocommerce_order_list_table_extra_tablenav', array('SyncBasalamCheckOrdersButton', 'showButtonOnTopList'), 20, 1);
        add_action('restrict_manage_posts', ['SyncBasalamCheckOrdersButton', 'showButtonOnTopList']);

        add_action('add_meta_boxes', array(new SyncBasalamOrderMetaBox, 'registerMetaBox'), 10);
        add_action('restrict_manage_posts', [
            SyncBasalamProductFilter::getInstance(),
            'renderFilterDropdown'
        ]);

        add_action('pre_get_posts', [
            SyncBasalamProductFilter::getInstance(),
            'applyFilterToQuery'
        ]);
    }

    private function initListener()
    {
        $listeners = [
            'woocommerce_update_product' => new SyncBasalamUpdateWooProduct(),
            'save_post' => new SyncBasalamCreateWooProduct(),
            'untrashed_post' => new SyncBasalamRestoreProductListener(),
            'wp_trash_post' => new SyncBasalamArchiveProductListener(),
        ];

        foreach ($listeners as $event => $listener) {
            add_action($event, function ($data) use ($listener, $event) {
                $listener->initHook($event, $data);
            }, 10, 2);
        }
    }

    private function initWpBgProcess()
    {
        $dispatchers = [
            new SyncBasalamBulkUpdateProducts(),
            new SyncBasalamProductsConnectDispatcher(),
            new SyncBasalamCreateProduct(),
            new SyncBasalamUpdateProduct(),
        ];
        foreach ($dispatchers as $dispatcher) {
            $className = get_class($dispatcher);
            global ${$className};
            ${$className} = $dispatcher;
        }
    }
    private function initTasks()
    {
        $taskFiles = glob(SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'queue/tasks/class-sync-basalam-*.php');
        foreach ($taskFiles as $taskFile) {
            require_once $taskFile;

            $filename = basename($taskFile, '.php');
            $filename = str_replace('class-sync-basalam-', '', $filename);
            $parts = explode('-', $filename);
            $className = 'SyncBasalam' . implode('', array_map('ucfirst', $parts));

            if (class_exists($className) && is_subclass_of($className, 'SyncBasalamQueueAbstract')) {
                $task = new $className();
                $task->registerHooks();
            }
        }

        $clearLogsExist = WC()->queue()->search([
            'hook'     => 'sync_basalam_plugin_clear_log_files',
            'status'   => 'pending',
            'per_page' => 1,
        ]);

        if (!$clearLogsExist) {
            (new SyncBasalamClearLogFiles())->schedule(null);
        }
    }

    public function pluginUrl()
    {
        return plugin_dir_url(SYNC_BASALAM_PLUGIN_INCLUDES_DIR);
    }

    public function pluginPath()
    {
        return untrailingslashit(SYNC_BASALAM_PLUGIN_DIR);
    }

    public function templatePath($path = null)
    {

        $path = $path ? "/" . $path : null;

        return $this->pluginPath() . "/templates" . $path;
    }

    public function assetsUrl($path = null)
    {

        $path = $path ? "/" . $path : null;

        return $this->pluginUrl() . "assets" . $path;
    }

    public function adminEnqueueStyles()
    {
        wp_enqueue_style(
            'basalam-admin-style',
            $this->assetsUrl("css/style.css"),
            array(),
            SYNC_BASALAM_PLUGIN_VERSION
        );
        wp_enqueue_style(
            'basalam-admin-font-style',
            $this->assetsUrl("css/font.css"),
            array(),
            SYNC_BASALAM_PLUGIN_VERSION
        );
        wp_enqueue_style(
            'basalam-admin-social-style',
            $this->assetsUrl("css/social.css"),
            array(),
            SYNC_BASALAM_PLUGIN_VERSION
        );
        wp_enqueue_style(
            'basalam-admin-logs-style',
            $this->assetsUrl("css/logs.css"),
            array(),
            SYNC_BASALAM_PLUGIN_VERSION
        );
        wp_enqueue_style(
            'basalam-admin-onboarding-style',
            $this->assetsUrl("css/onboarding.css"),
            array(),
            SYNC_BASALAM_PLUGIN_VERSION
        );
    }

    public function adminEnqueueScripts()
    {
        wp_enqueue_script(
            'basalam-admin-logs-script',
            $this->assetsUrl("js/logs.js"),
            array('jquery'),
            SYNC_BASALAM_PLUGIN_VERSION,
            true
        );
        wp_enqueue_script(
            'basalam-admin-help-script',
            $this->assetsUrl("js/help.js"),
            array('jquery'),
            SYNC_BASALAM_PLUGIN_VERSION,
            true
        );
        wp_enqueue_script(
            'basalam-admin-product-fields-script',
            $this->assetsUrl("js/product-fields.js"),
            array('jquery'),
            SYNC_BASALAM_PLUGIN_VERSION,
            true
        );
        wp_enqueue_script(
            'basalam-admin-manage-box-script',
            $this->assetsUrl("js/manage-box.js"),
            array('jquery'),
            SYNC_BASALAM_PLUGIN_VERSION,
            true
        );
        wp_enqueue_script(
            'basalam-admin-connect-modal-script',
            $this->assetsUrl("js/connect-modal.js"),
            array('jquery'),
            SYNC_BASALAM_PLUGIN_VERSION,
            true
        );
        wp_enqueue_script(
            'basalam-round-script',
            $this->assetsUrl("js/round.js"),
            array('jquery'),
            SYNC_BASALAM_PLUGIN_VERSION,
            true
        );
        wp_enqueue_script(
            'basalam-get-category-script',
            $this->assetsUrl("js/get-category.js"),
            array('jquery'),
            SYNC_BASALAM_PLUGIN_VERSION,
            true
        );
        wp_enqueue_script(
            'basalam-order-script',
            $this->assetsUrl("js/order.js"),
            array('jquery'),
            SYNC_BASALAM_PLUGIN_VERSION,
            true
        );
        wp_enqueue_script(
            'basalam-admin-script',
            $this->assetsUrl("js/admin.js"),
            array('jquery'),
            SYNC_BASALAM_PLUGIN_VERSION,
            true
        );
        wp_enqueue_script(
            'basalam-check-sync-script',
            $this->assetsUrl("js/check-sync.js"),
            array('jquery'),
            SYNC_BASALAM_PLUGIN_VERSION,
            true
        );
        wp_enqueue_script(
            'basalam-map-category-option-script',
            $this->assetsUrl("js/map-category-option.js"),
            array('jquery'),
            SYNC_BASALAM_PLUGIN_VERSION,
            true
        );

        wp_enqueue_script(
            'basalam-generate-product-variation-script',
            $this->assetsUrl("js/generate-product-variation.js"),
            array('jquery'),
            SYNC_BASALAM_PLUGIN_VERSION,
            true
        );
    }

    public function processDiscountTasksCron()
    {
        try {
            require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-discount-task-model.php';
            require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-discount-task-processor.php';
            require_once SYNC_BASALAM_PLUGIN_INCLUDES_DIR . 'services/class-sync-basalam-discount-manager.php';
            $processor = new SyncBasalamDiscountTaskProcessor();
            $processor->processSingleDiscountGroup();
        } catch (Exception $e) {
            error_log('Discount processor cron exception: ' . $e->getMessage());
        }
    }
}
