<?php
if (! defined('ABSPATH')) exit;

class SyncBasalamOrderEndpoint
{
    public static function registerRoutes()
    {
        register_rest_route(
            'sync-basalam',
            '/v1/order-manager',
            array(
                'methods'             => 'POST',
                'callback'            => array('SyncBasalamOrderManger', 'orderManger'),
                'permission_callback' => array(__CLASS__, 'checkPermissions'),
            )
        );
    }

    public static function checkPermissions($request)
    {
        $webhook_token = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::WEBHOOK_HEADER_TOKEN);

        $headers = $request->get_headers();

        if (!isset($headers['token'][0])) {
            $webhookService = new SyncBasalamWebhookService();
            $webhookService->setupWebhook();
            SyncBasalamLogger::error("سفارش جدیدی در باسلام ثبت شد ، اما توکن ارسال نشد");
            return false;
        }

        $receive_token = sanitize_text_field($headers['token'][0]);

        if ($receive_token === $webhook_token) {
            return true;
        } else {
            $webhookService = new SyncBasalamWebhookService();
            $webhookService->setupWebhook();
            SyncBasalamLogger::error("سفارش جدیدی در باسلام ایجاد شد اما توکن ارسالی معتبر نیست.");
            return false;
        }
    }
}
