<?php
if (! defined('ABSPATH')) exit;

class SyncBasalamProductStatusColumn
{

    public static function registerStatusColumn($columns)
    {
        $newColumns = array();
        foreach ($columns as $key => $value) {
            $newColumns[$key] = $value;
            if ($key === 'price') {
                $newColumns['basalam_status'] = 'وضعیت محصول (باسلام)';
            }
        }
        return $newColumns;
    }

    public static function renderStatusColumnContent($column, $productId)
    {
        if ($column === 'basalam_status') {
            $product = get_post_meta($productId, 'sync_basalam_product_sync_status', true);

            if ($product && $product == 'ok') {
                SyncBasalamAdminUI::renderSyncProductStatusOk();
            } elseif ($product == 'pending') {
                SyncBasalamAdminUI::renderSyncProductStatusPending();
            } else {
                SyncBasalamAdminUI::renderSyncProductStatusFail();
            }
        }
    }
}
