<?php
if (! defined('ABSPATH')) exit;

class SyncBasalamProductMetaBox
{

    public static function registerMetaBox()
    {
        global $post;
        $productId = $post->ID;
        $productStatus = get_post_meta($productId, 'sync_basalam_product_sync_status', true);

        switch ($productStatus) {
            case 'ok':
                $statusColor   = 'var(--basalam-success-color)';
                $statusTooltip = 'محصول در باسلام در دسترس است.';
                break;
            case 'pending':
                $statusColor   = 'var(--basalam-primary-color)';
                $statusTooltip = 'محصول در حال اجرای عملیات است.';
                break;
            default:
                $statusColor   = 'var(--basalam-danger-color)';
                $statusTooltip = 'محصول در باسلام در دسترس نیست.';
                break;
        }

        add_meta_box(
            'sync_basalam_single_product_manage_box',
            'تنظیمات باسلام <span title="' . esc_attr($statusTooltip) . '" class="basalam-status-circle" style="background-color:' . esc_attr($statusColor) . ';">
                <img src="' . esc_url(syncBasalamPlugin()->assetsUrl() . "/icons/info.svg") . '" alt="" style="width: 15px;">
                </span>',
            array('SyncBasalamProductMetaBox', 'renderMetaBox'),
            'product',
            'side',
            'high'
        );
    }

    public static function renderMetaBox($post)
    {
        $productId = $post->ID;
        $productStatus = get_post_status($productId);

        $basalamProductStatus = get_post_meta($productId, 'sync_basalam_product_status', true);
        $basalamProductSyncStatus = get_post_meta($productId, 'sync_basalam_product_sync_status', true);

        $syncBasalamToken = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::TOKEN);
        $syncBasalamVendorId = SyncBasalamAdminSettings::getSettings(SyncBasalamAdminSettings::VENDOR_ID);

        if ($productStatus == 'publish') {
            if ($basalamProductSyncStatus == 'pending') {
                echo '<p class="basalam-p" style="font-size:12px;">یک عملیات برای این محصول در جریان است.</p>';
            } elseif (!$syncBasalamToken || !$syncBasalamVendorId) {
                echo '<p class="basalam-p" style="font-size:12px;">دسترسی های لازم دریافت نشده است ، ابتدا دسترسی ها را <a href="/wp-admin/admin.php?page=sync_basalam" target="_blank">دریافت</a> نمایید.</p>';
            } else {
                if ($basalamProductStatus) {
                    $syncBasalamProductId = get_post_meta($productId, 'sync_basalam_product_id', true);
                    SyncBasalamAdminUI::renderBtn('بروزسانی محصول در باسلام', false, 'update_product_in_basalam', $post->ID, 'update_product_in_basalam_nonce');
                    if ($basalamProductStatus == 2976) {
                        SyncBasalamAdminUI::renderBtn('آرشیو کردن محصول در باسلام', false, 'archive_exist_product_on_basalam', $post->ID, 'archive_exist_product_on_basalam_nonce');
                    } else {
                        SyncBasalamAdminUI::renderBtn('بازگردانی محصول در باسلام', false, 'restore_exist_product_on_basalam', $post->ID, 'restore_exist_product_on_basalam_nonce');
                    }
                    $link = "https://basalam.com/p/" . $syncBasalamProductId;
                    SyncBasalamAdminUI::renderBtn('مشاهده محصول در باسلام', $link);
                    SyncBasalamAdminUI::renderBtn('قطع اتصال محصول', false, 'disconnect_exist_product_on_basalam', $post->ID, 'disconnect_exist_product_on_basalam_nonce');
                } else {
                    SyncBasalamAdminUI::renderBtn('اضافه کردن محصول در باسلام', false, 'create_product_basalam', $post->ID, 'create_product_basalam_nonce');
                    require_once syncBasalamPlugin()->templatePath("admin/utilities/connect-button-single-product-page.php");
                }
            }
        } else {
            echo '<p class="basalam-p" style="font-size:12px;">برای دسترسی به تنظیمات باسلام ، وضعیت محصول را به "منتشر شده" تغییر دهید.</p>';
        }
        $nonceGetBasalamCategoryIdsAction = 'basalam_get_category_ids_nonce';
        $nonceGetBasalamCategoryIdValue  = wp_create_nonce($nonceGetBasalamCategoryIdsAction);
        echo '<hr>';
        echo '<div>
            <button type="button" id="basalam_fetch_categories_btn" class="button button-primary basalam-p" style="width: 100%; background: var(--basalam-primary-color); border: none; color: white; padding: 0px !important; cursor: pointer;">
                دریافت دسته‌بندی‌های پیشنهادی باسلام
            </button>
            <input type="hidden"  id="basalam_get_category_ids_nonce" value="' . esc_attr($nonceGetBasalamCategoryIdValue) . '">
        </div>
        <div id="sync_basalam_category_id" class="basalam-p__small basalam--hidden">
            </div>';

        $nonceGetBasalamCategoryAttrAction = 'basalam_get_category_attrs_nonce';
        $nonceGetBasalamCategoryAttrValue  = wp_create_nonce($nonceGetBasalamCategoryAttrAction);

        echo '<div id="sync_basalam_category_attributes" class="basalam-p__small basalam--hidden">
            <input type="hidden"  id="basalam_get_category_attrs_nonce" value="' . esc_attr($nonceGetBasalamCategoryAttrValue) . '">
            </div>';
    }
}
