<?php
if (! defined('ABSPATH')) exit;

class SyncBasalamMobileProductFields
{
    static function renderCheckbox()
    {
        $isMobileProduct = get_post_meta(get_the_ID(), '_sync_basalam_is_mobile_product_checkbox', true);
        $checked = ($isMobileProduct === 'yes') ? 'yes' : 'no';

        woocommerce_wp_checkbox(array(
            'id'            => '_sync_basalam_is_mobile_product_checkbox',
            'label'         => 'محصول موبایلی(باسلام)',
            'description'   => 'در صورتی که محصول شما موبایل است ، این گزینه را فعال نمایید .',
            'desc_tip'      => true,
            'value'         => $checked
        ));

        wp_nonce_field('sync_basalam_save_mobile_fields_action', '_sync_basalam_mobile_fields_nonce');

        self::renderFields($checked);
    }

    static function renderFields($checked)
    {
        $fields = array(
            '_sync_basalam_mobile_storage'     => 'حافظه داخلی*',
            '_sync_basalam_cpu_type'           => 'نوع پردازنده - CPU*',
            '_sync_basalam_mobile_ram'         => 'حافظه RAM*',
            '_sync_basalam_screen_size'        => 'سایز صفحه نمایش*',
            '_sync_basalam_rear_camera'        => 'دوربین پشت*',
            '_sync_basalam_battery_capacity'   => 'ظرفیت باتری*',
        );

        echo '<div id="basalam_mobile_product_fields" style="display:' . ($checked === 'yes' ? 'block' : 'none') . ';">';

        foreach ($fields as $id => $label) {
            woocommerce_wp_text_input(array(
                'id'    => $id,
                'label' => $label,
                'type'  => 'text',
                'value' => get_post_meta(get_the_ID(), $id, true),
            ));
        }

        echo '</div>';
    }

    static function saveCheckbox($postId)
    {
        if (
            !isset($_POST['_sync_basalam_mobile_fields_nonce']) ||
            !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['_sync_basalam_mobile_fields_nonce'])), 'sync_basalam_save_mobile_fields_action')
        ) {
            return;
        }

        $syncBasalamIsMobileCheckboxValue = isset($_POST['_sync_basalam_is_mobile_product_checkbox']) ? 'yes' : 'no';
        update_post_meta($postId, '_sync_basalam_is_mobile_product_checkbox', $syncBasalamIsMobileCheckboxValue);

        if ($syncBasalamIsMobileCheckboxValue === 'no') {
            self::deleteFields($postId);
        } else {
            self::saveFields($postId);
        }
    }

    static function deleteFields($postId)
    {
        $fields = array(
            '_sync_basalam_mobile_storage',
            '_sync_basalam_cpu_type',
            '_sync_basalam_mobile_ram',
            '_sync_basalam_screen_size',
            '_sync_basalam_rear_camera',
            '_sync_basalam_battery_capacity'
        );

        foreach ($fields as $field) {
            delete_post_meta($postId, $field);
        }
    }

    static function saveFields($postId)
    {
        if (
            !isset($_POST['_sync_basalam_mobile_fields_nonce']) ||
            !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['_sync_basalam_mobile_fields_nonce'])), 'sync_basalam_save_mobile_fields_action')
        ) {
            return;
        }

        $fields = array(
            '_sync_basalam_mobile_storage'     => '',
            '_sync_basalam_cpu_type'           => '',
            '_sync_basalam_mobile_ram'         => '',
            '_sync_basalam_screen_size'        => '',
            '_sync_basalam_rear_camera'        => '',
            '_sync_basalam_battery_capacity'   => ''
        );

        foreach ($fields as $fieldKey => $defaultValue) {
            if (isset($_POST[$fieldKey])) {
                update_post_meta(
                    $postId,
                    $fieldKey,
                    sanitize_text_field(wp_unslash($_POST[$fieldKey]))
                );
            }
        }
    }
}
