<?php
if (! defined('ABSPATH')) exit;
class SyncBasalamBulkProductActions
{
    private static $instance = null;

    public static function getInstance()
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function registerBulkActions($actions)
    {
        $actions['add_to_basalam'] = 'افزودن به باسلام';
        $actions['update_on_basalam'] = 'آپدیت در باسلام';
        $actions['disconnect_basalam_product'] = 'قطع اتصال محصول باسلام';
        return $actions;
    }

    public function handleBulkAction($redirectTo, $doaction, $postIds)
    {
        if (
            !isset($_REQUEST['_wpnonce']) ||
            !wp_verify_nonce(sanitize_text_field(wp_unslash($_REQUEST['_wpnonce'])), 'bulk-posts')
        ) {
            wp_die('درخواست نامعتبر است. لطفاً دوباره تلاش کنید.');
        }

        $added = 0;
        $updated = 0;

        if ($doaction === 'add_to_basalam') {
            SyncBasalamProductService::enqueueSelectedProductsForCreation($postIds);
            $redirectTo = add_query_arg('sync_basalam_added', $added, $redirectTo);
        }

        if ($doaction === 'update_on_basalam') {
            SyncBasalamProductService::enqueueSelectedProductsForUpdate($postIds);
            $redirectTo = add_query_arg('sync_basalam_updated', $updated, $redirectTo);
        }

        if ($doaction === 'disconnect_basalam_product') {
            SyncBasalamProductService::disconnectSelectedProducts($postIds);
            $redirectTo = add_query_arg('sync_basalam_disconnected_products', $updated, $redirectTo);
        }

        return $redirectTo;
    }
}
