<?php
if (! defined('ABSPATH')) exit;
class SyncBasalamAdminProductOperations
{
    private const STATUS_ACTIVE = 2976;
    private const STATUS_ARCHIVED = 3790;

    private $updateProductService;
    private $createProductService;
    private $discountHandler;

    public function __construct()
    {
        $this->updateProductService = new SyncBasalamUpdateSingleProductService();
        $this->createProductService = new SyncBasalamCreateSingleProductService();
        $this->discountHandler = new SyncBasalamProductDiscountHandler();
    }

    public function updateExistProduct($product_id, $category_ids = null)
    {
        try {
            $productData = $this->getProductData($product_id, 'update', $category_ids);
            $updateResult = $this->updateProductService->updateProductInBasalam($productData, $product_id);
            $this->discountHandler->handle($product_id);

            return $updateResult;
        } catch (\Throwable $th) {
            update_post_meta($product_id, 'sync_basalam_product_sync_status', 'no');
            SyncBasalamLogger::error("خطا در بروزرسانی محصول: " . $th->getMessage(), [
                'product_id' => $product_id,
                'عملیات' => 'بروزرسانی محصول باسلام',
            ]);

            return [
                'success' => false,
                'message' => 'فرایند به روزرسانی محصول ناموفق بود : ' . $th->getMessage(),
                'error' => $th->getMessage(),
                'status_code' => 400
            ];
        }
    }

    public function createNewProduct($product_id, $category_ids)
    {
        try {
            $productData = $this->getProductData($product_id, false, $category_ids);
            $createResult = $this->createProductService->createProductInBasalam($productData, $product_id);
            $this->discountHandler->handle($product_id);

            return $createResult;
        } catch (\Throwable $th) {
            update_post_meta($product_id, 'sync_basalam_product_sync_status', 'no');
            SyncBasalamLogger::error("خطا در اضافه کردن محصول: " . $th->getMessage(), [
                'product_id' => $product_id,
                'عملیات' => 'اضافه کردن محصول به باسلام',
            ]);

            return [
                'success' => false,
                'message' => 'فرایند اضافه کردن محصول ناموفق بود : ' . $th->getMessage(),
                'status_code' => 400
            ];
        }
    }

    public function restoreExistProduct($product_id)
    {
        try {
            $result = $this->updateProductService->updateProductStatus($product_id, self::STATUS_ACTIVE);
            if ($result) {
                return $result;
            }
            throw new \Exception('Failed to restore product status');
        } catch (\Throwable $th) {
            return [
                'success' => false,
                'message' => 'تغییر وضعیت محصول در باسلام ناموفق بود : ' . $th->getMessage(),
                'status_code' => 400
            ];
        }
    }

    public function archiveExistProduct($product_id)
    {
        try {
            $result = $this->updateProductService->updateProductStatus($product_id, self::STATUS_ARCHIVED);
            if ($result) {
                return $result;
            }
            throw new \Exception('Failed to archive product status');
        } catch (\Throwable $th) {
            return [
                'success' => false,
                'message' => 'تغییر وضعیت محصول در باسلام ناموفق بود : ' . $th->getMessage(),
                'status_code' => 400
            ];
        }
    }

    private function getProductData($product_id, $is_update = false, $category_ids = null)
    {
        $dataHandler = new SyncBasalamGetProductData();
        $productData = $dataHandler->getProductData($product_id, $is_update, $category_ids);
        return $productData;
    }

    public static function disconnectProduct($product_id)
    {
        $metaKeysToRemove = [
            'sync_basalam_product_id',
            'sync_basalam_product_sync_status',
            'sync_basalam_product_status',
        ];

        foreach ($metaKeysToRemove as $metaKey) {
            delete_post_meta($product_id, $metaKey);
        }

        $product = wc_get_product($product_id);

        if ($product && $product->is_type('variable')) {
            $variationIds = $product->get_children();
            foreach ($variationIds as $variationId) {
                delete_post_meta($variationId, 'sync_basalam_variation_id');
            }
        }

        return [
            'success' => true,
            'message' => 'اتصال محصولات با موفقیت حذف شد.',
            'status_code' => 200
        ];
    }
}
