<?php
class SyncBasalamOrderStatuses
{
    public function orderStatuses($orderStatuses)
    {
        $orderStatuses['wc-bslm-rejected'] = '(باسلام) لغو شده';
        $orderStatuses['wc-bslm-preparation'] = '(باسلام) آماده‌سازی سفارش';
        $orderStatuses['wc-bslm-wait-vendor'] = '(باسلام) در انتظار تایید غرفه دار';
        $orderStatuses['wc-bslm-shipping'] = '(باسلام) ارسال سفارش برای مشتری';
        $orderStatuses['wc-bslm-completed'] = '(باسلام) تکمیل شده';
        return $orderStatuses;
    }

    public function registerOrderStatuses()
    {
        $statuses = [
            'wc-bslm-rejected' => 'لغو شده',
            'wc-bslm-wait-vendor' => 'در انتظار تایید غرفه دار',
            'wc-bslm-preparation' => 'حال آماده‌سازی سفارش',
            'wc-bslm-shipping' => 'ارسال سفارش برای مشتری',
            'wc-bslm-completed' => 'تکمیل شده'
        ];

        foreach ($statuses as $key => $label) {
            register_post_status($key, [
                'label' => $label,
                'public' => true,
                'exclude_from_search' => false,
                'show_in_admin_all_list' => true,
                'show_in_admin_status_list' => true,
                'post_type' => ['shop_order', 'wc_order'],
                'wc_status' => true
            ]);
        }
    }
}
