<?php
if (! defined('ABSPATH')) exit;

class SyncBasalamMenus
{

    public static function registerMenus()
    {

        add_menu_page(
            'ووسلام',
            'ووسلام',
            'manage_options',
            'sync_basalam',
            array('SyncBasalamMainPage', 'render'),
            plugin_dir_url(__FILE__) . '../../assets/images/logowoosalam.png',
            4
        );

        add_submenu_page(
            'sync_basalam',
            'خانه',
            SyncBasalamAdminUI::renderIcon('dashicons-admin-home') . 'خانه',
            'manage_options',
            'sync_basalam',
            array('SyncBasalamMainPage', 'render')
        );

        add_submenu_page(
            'sync_basalam',
            'لاگ ها',
            SyncBasalamAdminUI::renderIcon('dashicons-list-view') . 'لاگ ها',
            'manage_options',
            'sync_basalam_logs',
            array('SyncBasalamLogsPage', 'render')
        );

        add_submenu_page(
            'sync_basalam',
            'اطلاعات',
            SyncBasalamAdminUI::renderIcon('dashicons-info') . 'اطلاعات',
            'manage_options',
            'sync_basalam_vendor_info',
            array('SyncBasalamInfoPage', 'render')
        );

        add_submenu_page(
            'sync_basalam',
            'راهنما',
            SyncBasalamAdminUI::renderIcon('dashicons-book-alt') . 'راهنما',
            'manage_options',
            'sync_basalam_help',
            array('SyncBasalamHelpPage', 'render')
        );

        add_submenu_page(
            'sync_basalam',
            'اتصال دسته‌بندی‌ها',
            SyncBasalamAdminUI::renderIcon('dashicons-category') . 'اتصال دسته‌بندی‌ها',
            'manage_options',
            'sync_basalam_category_mapping',
            array('SyncBasalamCategoryMappingPage', 'render')
        );

        if (class_exists('Digikala\Admin\Menus')) {
            \Digikala\Admin\Menus::register();
        }

        add_submenu_page(
            'آنبوردینگ',
            'آنبوردینگ باسلام',
            'آموزش باسلام',
            'manage_options',
            'basalam-onboarding',
            array('SyncBasalamOnboardingPage', 'render')
        );

        add_submenu_page(
            'ذخیره اطلاعات',
            'ذخیره اطلاعات',
            'ذخیره اطلاعات',
            'manage_options',
            'basalam-save-token',
            array('SyncBasalamAdminSettings', 'saveOauthData')
        );

        add_submenu_page(
            'محصولات باسلام سینک نشده با ووکامرس',
            'محصولات باسلام سینک نشده با ووکامرس',
            'محصولات باسلام سینک نشده با ووکامرس',
            'manage_options',
            'basalam-show-products',
            array('SyncBasalamUnsyncedProductsPage', 'render')
        );
    }
}
