<?php
if (! defined('ABSPATH')) exit;
class SyncBasalamFaq
{
    private static $categories = ['عمومی', 'تنظیمات', 'محصولات', 'سفارشات', 'همگام‌سازی'];
    public static function getCategories()
    {
        return self::$categories;
    }
    public static function getFaqByCategory($category)
    {
        $faqs = self::getFaqData();
        $categoryFaqs = array_filter($faqs, function ($faq) use ($category) {
            return $faq['category'] === $category;
        });
        return $categoryFaqs;
    }
    public static function getFaqData()
    {
        $faqs = array(

            array(
                'question' => 'افزونه ووکامرس باسلام چیست؟',
                'answer' => 'افزونه ووکامرس باسلام یک پل ارتباطی میان سایت شما و غرفه باسلامتان است که به شما امکان می‌دهد محصولات فروشگاه ووکامرس خود را به صورت خودکار در باسلام مدیریت کنید. با استفاده از این افزونه، تمام تغییرات محصولات شما (قیمت، موجودی، تصاویر و...) به صورت خودکار در باسلام نیز اعمال می‌شود.',
                'category' => 'عمومی'
            ),
            array(
                'question' => 'چه امکاناتی در افزونه وجود دارد؟',
                'answer' => 'افزونه باسلام امکانات متنوعی را ارائه می‌دهد از جمله: همگام‌سازی خودکار محصولات، مدیریت موجودی و قیمت، تنظیم زمان آماده‌سازی و وزن پیش‌فرض برای محصولات، و امکان فعال‌سازی حالت توسعه‌دهنده برای عیب‌یابی و...',
                'category' => 'عمومی'
            ),
            array(
                'question' => 'چگونه با پشتیبانی فنی ارتباط برقرار کنم؟',
                'answer' => 'شما می‌توانید از طریق گروه‌های تلگرام و بله با تیم توسعه پلاگین در ارتباط باشید. آدرس این گروه‌ها را می‌توانید در تب "اطلاعات" مشاهده کنید. تیم پشتیبانی در ساعات کاری آماده پاسخگویی به سؤالات شما است.',
                'category' => 'عمومی'
            ),
            array(
                'question' => 'آیا استفاده از افزونه رایگان است؟',
                'answer' => 'بله، استفاده از افزونه کاملاً رایگان است و هیچ هزینه‌ای برای نصب و استفاده از آن وجود ندارد. تنها نیاز است که در باسلام اکانت فروشنده داشته باشید.',
                'category' => 'عمومی'
            ),
            array(
                'question' => 'آیا افزونه نیاز به بروزرسانی دارد؟',
                'answer' => 'بله، افزونه به صورت مداوم در حال بهبود است و توصیه می‌شود همیشه از آخرین نسخه استفاده کنید. بروزرسانی‌ها شامل بهبود عملکرد، رفع باگ‌ها و افزودن امکانات جدید است.',
                'category' => 'عمومی'
            ),

            array(
                'question' => 'چگونه افزونه را نصب و راه‌اندازی کنم؟',
                'answer' => 'از منوی افزونه‌ها در وردپرس افزونه را نصب و فعال کنید، به منوی باسلام بروید، توکن و شناسه کلاینت را از پنل باسلام دریافت و در تنظیمات وارد کنید، شناسه وب‌هوک را دریافت و ثبت کنید، و در نهایت تنظیمات پیش‌فرض را انجام دهید.',
                'category' => 'تنظیمات'
            ),
            array(
                'question' => 'توکن و شناسه کلاینت را از کجا دریافت کنم؟',
                'answer' => 'وارد پنل فروشندگان باسلام شوید، به بخش API در منوی باسلام مراجعه کنید، درخواست دسترسی API را ثبت کنید و پس از تأیید، توکن و شناسه کلاینت برای شما صادر می‌شود.',
                'category' => 'تنظیمات'
            ),
            array(
                'question' => 'چگونه تنظیمات پیش‌فرض محصولات را تغییر دهم؟',
                'answer' => 'در بخش تنظیمات افزونه می‌توانید وزن پیش‌فرض محصولات بر حسب گرم و زمان آماده‌سازی پیش‌فرض محصولات بر حسب روز را تنظیم کنید.',
                'category' => 'تنظیمات'
            ),
            array(
                'question' => 'حالت توسعه‌دهنده چیست و چه کاربردی دارد؟',
                'answer' => 'حالت توسعه‌دهنده برای عیب‌یابی و مشاهده جزئیات خطاها استفاده می‌شود. در این حالت، پیام‌های خطا و لاگ‌های سیستم با جزئیات بیشتری نمایش داده می‌شوند.',
                'category' => 'تنظیمات'
            ),
            array(
                'question' => 'چگونه می‌توانم تنظیمات را به حالت اولیه برگردانم؟',
                'answer' => 'برای بازگرداندن تنظیمات به حالت اولیه، می‌توانید افزونه را غیرفعال و سپس حذف کنید. پس از نصب مجدد، تنظیمات به حالت پیش‌فرض برمی‌گردد.',
                'category' => 'تنظیمات'
            ),

            array(
                'question' => 'همگام‌سازی خودکار چگونه کار می‌کند؟',
                'answer' => 'با فعال کردن همگام‌سازی خودکار، هر تغییری که در محصولات ووکامرس ایجاد کنید به صورت خودکار در باسلام نیز اعمال می‌شود.',
                'category' => 'همگام‌سازی'
            ),
            array(
                'question' => 'چگونه همه محصولات را یکجا به باسلام ارسال کنم؟',
                'answer' => ' روی دکمه اضافه کردن محصولات به باسلام کلیک کنید ، باقی فرایند به صورت اتوماتیک انجام میشود',
                'category' => 'همگام‌سازی'
            ),
            array(
                'question' => 'چرا بعضی محصولات همگام‌سازی نمی‌شوند؟',
                'answer' => 'دلایل احتمالی: محصول قیمت یا موجودی ندارد، تصویر شاخص ندارد، در وضعیت پیش‌نویس است یا مشکل در اتصال به API باسلام وجود دارد.',
                'category' => 'همگام‌سازی'
            ),
            array(
                'question' => 'آیا می‌توانم همگام‌سازی را موقتاً غیرفعال کنم؟',
                'answer' => 'بله، می‌توانید از طریق دکمه وضعیت همگام‌سازی در داشبورد افزونه، همگام‌سازی خودکار را غیرفعال کنید و هر زمان که خواستید مجدداً آن را فعال کنید.',
                'category' => 'همگام‌سازی'
            ),
            array(
                'question' => 'چه اطلاعاتی از محصول در باسلام قرار میگیرند؟',
                'answer' => 'اطلاعات همگام‌سازی شده شامل: نام محصول، قیمت، موجودی، تصاویر، توضیحات، دسته‌بندی، وزن و زمان اماده سازی محصول است.',
                'category' => 'همگام‌سازی'
            ),

            array(
                'question' => 'چگونه محصولات را به باسلام اضافه کنم؟',
                'answer' => 'سه روش وجود دارد : اضافه کردن محصول جدید به صورت تکی یا کلی ، اتصال محصول از صفحه ویرایش محصول به محصولات موجود غرفه باسلام',
                'category' => 'محصولات'
            ),
            array(
                'question' => 'چگونه قیمت و موجودی محصولات را به‌روز کنم؟',
                'answer' => 'به‌روزرسانی به دو روش انجام می‌شود: خودکار با فعال بودن همگام‌سازی خودکار که بعد از هر سفارش جدید موجودی و ... همگام سازی میشود، یا دستی از طریق دکمه به‌روزرسانی محصولات در باسلام در منوی باسلام یا بروزرسانی تکی محصول .',
                'category' => 'محصولات'
            ),
            array(
                'question' => 'آیا میتوانم محصولات متغیر هم به باسلام اضافه و آن را مدیریت کنم؟',
                'answer' => 'بله، افزونه از محصولات متغیر پشتیبانی می‌کند. ',
                'category' => 'محصولات'
            ),
            array(
                'question' => 'چگونه می‌توانم محصولات را از باسلام حذف کنم؟',
                'answer' => 'برای حذف محصول از باسلام می‌توانید در صفحه ویرایش محصول، گزینه آرشیو محصول را انتخاب کنید تا در غرفه باسلامی تان نمایش داده نشود ، برای نمایش مجدد می‌توانید از گزینه بازگردانی محصول استفاده کنید.                    ',
                'category' => 'محصولات'
            ),

            array(
                'question' => 'چگونه سفارشات باسلام را در ووکامرس مشاهده کنم؟',
                'answer' => 'در صورت فعال سازی گزینه همگام سازی سفارشات ، سفارشات باسلام به صورت خودکار در بخش سفارشات ووکامرس نمایش داده می‌شوند. شما می‌توانید با کلیک روی دکمه "بررسی سفارشات باسلام" در صفحه سفارشات، سفارشات جدید را همگام‌سازی کنید.',
                'category' => 'سفارشات'
            ),
            array(
                'question' => 'آیا سفارشات باسلام به صورت خودکار در ووکامرس ثبت می‌شوند؟',
                'answer' => 'بله، با فعال‌سازی همگام سازی سفارشات باسلام، سفارشات جدید به صورت خودکار در ووکامرس ثبت می‌شوند. در غیر این صورت، می‌توانید به صورت دستی با استفاده از دکمه "بررسی سفارشات باسلام" این کار را انجام دهید.',
                'category' => 'سفارشات'
            ),
            array(
                'question' => 'چگونه وضعیت سفارش را در باسلام به‌روز کنم؟',
                'answer' => 'در صورتی که وضعیت سفارشات ووکامرس ، باسلامی باشند ، از طریق باکس تنظیمات باسلام در صفحه سفارش با توجه به وضعیت سفارش آن را به روزرسانی کنید.',
                'category' => 'سفارشات'
            ),
            array(
                'question' => 'آیا می‌توانم سفارشات را به صورت دستی تأیید کنم؟',
                'answer' => 'بله، در بخش سفارشات ووکامرس می‌توانید سفارشات باسلام را به صورت دستی تأیید کنید. این کار از طریق دکمه "تأیید سفارش" در صفحه سفارش انجام می‌شود.',
                'category' => 'سفارشات'
            ),
        );
        return $faqs;
    }
}
