<?php
if (! defined('ABSPATH')) exit;

class SyncBasalamAdminSettings
{
    private static $oauthCache = null;
    const DEFAULT_WEIGHT = "default_weight";
    const DEFAULT_PACKAGE_WEIGHT = "default_package_weight";
    const DEFAULT_PREPARATION = "default_preparation";
    const DEFAULT_STOCK_QUANTITY = "default_stock_quantity";
    const WEBHOOK_ID = "webhook_id";
    const TOKEN = "token";
    const REFRESH_TOKEN = "refresh_token";
    const VENDOR_ID = "vendor_id";
    const IS_VENDOR = "is_vendor";
    const SYNC_STATUS_PRODUCT = "sync_status_product";
    const SYNC_STATUS_ORDER = "sync_status_order";
    const DEVELOPER_MODE = "developer_mode";
    const INCREASE_PRICE_VALUE = "increase_price_value";
    const ROUND_PRICE = "round_price";
    const EXPIRE_TOKEN_TIME = "expire_token_time";
    const WEBHOOK_HEADER_TOKEN = "webhook_header_token";
    const PRODUCT_PREFIX_TITLE = "product_prefix_title";
    const PRODUCT_SUFFIX_TITLE = "product_suffix_title";
    const SYNC_PRODUCT_FIELDS = "sync_product_fields";
    const SYNC_PRODUCT_FIELD_NAME = "sync_product_field_name";
    const SYNC_PRODUCT_FIELD_PHOTOS = "sync_product_field_photos";
    const SYNC_PRODUCT_FIELD_PRICE = "sync_product_field_price";
    const SYNC_PRODUCT_FIELD_STOCK = "sync_product_field_stock";
    const SYNC_PRODUCT_FIELD_WEIGHT = "sync_product_field_weight";
    const SYNC_PRODUCT_FIELD_DESCRIPTION = "sync_product_field_description";
    const SYNC_PRODUCT_FIELD_ATTR = "sync_product_field_attr";
    const AUTO_CONFIRM_ORDER = "auto_confirm_order";
    const ALL_PRODUCTS_WHOLESALE = "all_products_wholesale";
    const ADD_ATTR_TO_DESC_PRODUCT = "add_attr_to_desc_product";
    const ADD_SHORT_DESC_TO_DESC_PRODUCT = "add_short_desc_to_desc_product";
    const PRODUCT_PRICE_FIELD = "product_price_field";
    const ORDER_STATUES_TYPE = "order_statues_type";
    const PRODUCT_OPERATION_TYPE = "product_operation_type";
    const DISCOUNT_DURATION = "discount_duration";
    const TASKS_PER_MINUTE = "tasks_per_minute";
    const TASKS_PER_MINUTE_AUTO = "tasks_per_minute_auto";
    const PRODUCT_ATTRIBUTE_SUFFIX_ENABLED = "product_attribute_suffix_enabled";
    const PRODUCT_ATTRIBUTE_SUFFIX_PRIORITY = "product_attribute_suffix_priority";

    public static function getDefaultSettings()
    {
        return array(
            self::DEFAULT_WEIGHT        => 100,
            self::DEFAULT_PACKAGE_WEIGHT        => 50,
            self::DEFAULT_PREPARATION   => 1,
            self::WEBHOOK_ID    => null,
            self::TOKEN         => null,
            self::WEBHOOK_HEADER_TOKEN         => null,
            self::REFRESH_TOKEN => null,
            self::SYNC_STATUS_PRODUCT   => false,
            self::SYNC_STATUS_ORDER   => false,
            self::DEVELOPER_MODE        => false,
            self::VENDOR_ID     => null,
            self::IS_VENDOR     => true,
            self::INCREASE_PRICE_VALUE     => 0,
            self::ROUND_PRICE    => null,
            self::EXPIRE_TOKEN_TIME    => null,
            self::PRODUCT_PREFIX_TITLE    => null,
            self::PRODUCT_SUFFIX_TITLE    => null,
            self::DEFAULT_STOCK_QUANTITY    => 1,
            self::SYNC_PRODUCT_FIELDS => 'all',
            self::SYNC_PRODUCT_FIELD_NAME => 0,
            self::SYNC_PRODUCT_FIELD_PHOTOS => 0,
            self::SYNC_PRODUCT_FIELD_PRICE => 0,
            self::SYNC_PRODUCT_FIELD_STOCK => 0,
            self::SYNC_PRODUCT_FIELD_WEIGHT => 0,
            self::SYNC_PRODUCT_FIELD_DESCRIPTION => 0,
            self::SYNC_PRODUCT_FIELD_ATTR => 0,
            self::AUTO_CONFIRM_ORDER => false,
            self::ALL_PRODUCTS_WHOLESALE => 'none',
            self::ADD_ATTR_TO_DESC_PRODUCT => false,
            self::ADD_SHORT_DESC_TO_DESC_PRODUCT => false,
            self::PRODUCT_PRICE_FIELD => 'original_price',
            self::ORDER_STATUES_TYPE => 'woosalam_statuses',
            self::PRODUCT_OPERATION_TYPE => 'optimized',
            self::DISCOUNT_DURATION => 7,
            self::TASKS_PER_MINUTE => 10,
            self::TASKS_PER_MINUTE_AUTO => true,
            self::PRODUCT_ATTRIBUTE_SUFFIX_ENABLED => false,
            self::PRODUCT_ATTRIBUTE_SUFFIX_PRIORITY => '',
        );
    }

    public static function sanitizeSettings($input)
    {
        $input = array_merge(self::getSettings() ?: [], $input);

        $input[self::DEFAULT_WEIGHT] = absint($input[self::DEFAULT_WEIGHT]);
        $input[self::DEFAULT_PREPARATION] = absint($input[self::DEFAULT_PREPARATION]);

        return $input;
    }

    public static function getSettings($setting = null)
    {
        $settings = (array) get_option('sync_basalam_settings', self::getDefaultSettings());
        if ($setting == null || !array_key_exists($setting, $settings)) {
            $defaultSettings = self::getDefaultSettings();

            foreach ($defaultSettings as $key => $value) {
                if (!array_key_exists($key, $settings)) {
                    $settings[$key] = $value;
                }
            }

            update_option('sync_basalam_settings', $settings);
            return $settings;
        }
        return $settings[$setting] ?? null;
    }

    public static function getOauthData($forceRefresh = false)
    {
        if (!$forceRefresh && self::$oauthCache !== null) {
            return self::$oauthCache;
        }

        $apiservice = new SyncBasalamApiServiceManager;
        $request = $apiservice->sendGetRequest('https://api.hamsalam.ir/api/v1/basalam-proxy/wp-oauth-data');
        $clientId = $request['data']['client_id'] ?? 779;
        $redirectUri = $request['data']['redirect_uri'] ?? 'https://api.hamsalam.ir/api/v1/basalam-proxy/wp-get-token';

        self::$oauthCache = [
            'client_id' => $clientId,
            'redirect_uri' => $redirectUri,
        ];

        return self::$oauthCache;
    }
    public static function getStaticSettings($setting = null)
    {
        $siteUrl = get_site_url();
        $scopes = "vendor.product.write vendor.parcel.write customer.profile.read vendor.profile.read vendor.parcel.read";
        $webhookToken = self::getSettings(SyncBasalamAdminSettings::WEBHOOK_HEADER_TOKEN);
        $vendorId = self::getSettings(SyncBasalamAdminSettings::VENDOR_ID);
        if (!$webhookToken) {
            $webhookToken = self::generateWebhookToken();
        }
        $SITE_URL_WEBHOOK = $siteUrl . '/wp-json/sync-basalam/v1/order-manager';
        $settings = array(
            'site_url' => $siteUrl,
            'site_url_webhook' => $SITE_URL_WEBHOOK,
            'url_get_all_sync_basalam_products' => "https://core.basalam.com/v3/vendors/$vendorId/products",
            'url_like_woo_on_basalam' => "https://apps-api.basalam.com/v1/apps/13/reviews",
            'url_get_sync_basalam_account_data' => "https://core.basalam.com/v3/users/me",
            'url_get_sync_basalam_orders' => "https://order-processing.basalam.com/v3/vendor-parcels",
            'get_webhooks_url_from_basalam' => "https://webhook.basalam.com/v1/webhooks",
            'discount_price_url' => "https://core.basalam.com/v3/vendors/{vendor_id}/discounts",
            'auto_confirm_order_url' => "https://order-processing.basalam.com/v1/vendor/automation-config",
            'update_bulk_products_url' => "https://core.basalam.com/v4/vendors/$vendorId/products?continue_on_error=true",
        );

        $oauthDependentSettings = ['redirect_uri', 'url_req_client', 'url_req_webhook', 'url_req_token'];

        if ($setting === null || in_array($setting, $oauthDependentSettings)) {
            $oauthData = self::getOauthData();
            $clientId = $oauthData['client_id'];
            $redirectUri = $oauthData['redirect_uri'];

            $settings['redirect_uri'] = $redirectUri;
            $settings['url_req_client'] = "https://developers.basalam.com/clients?name=WP-BASALAM&redirect_url=$redirectUri";
            $settings['url_req_webhook'] = "https://developers.basalam.com/panel/webhooks?events_ids=3,5,7&request_headers=" . urlencode(json_encode(["token" => $webhookToken])) . "&url=" . urlencode($SITE_URL_WEBHOOK);
            $settings['url_req_token'] = "https://basalam.com/accounts/sso?client_id=$clientId&scope=$scopes&redirect_uri=$redirectUri&state=$siteUrl";
        }

        if ($setting == null) {
            return $settings;
        }

        return $settings[$setting];
    }

    public static function saveSettings()
    {
        $data = isset($_POST['sync_basalam_settings']) ? array_map('sanitize_text_field', wp_unslash($_POST['sync_basalam_settings'])) : [];

        if ($data) {
            self::updateSettings($data);

            if (!empty($data[self::DEVELOPER_MODE]) && $data[self::DEVELOPER_MODE] === 'true') {
                $debugTask = new SyncBasalamDebug();
                $debugTask->schedule();
            } else {
                (new SyncBasalamCancelDebug())();
            }
        }

        if (isset($_POST['get_token']) && $_POST['get_token'] == 1) {
            $oauthData = self::getOauthData(true);
            $siteUrl = get_site_url();
            $scopes = "vendor.product.write vendor.parcel.write customer.profile.read vendor.profile.read vendor.parcel.read";
            $urlReqToken = "https://basalam.com/accounts/sso?client_id={$oauthData['client_id']}&scope=$scopes&redirect_uri={$oauthData['redirect_uri']}&state=$siteUrl";
            wp_redirect($urlReqToken);
            exit();
        }
    }

    public static function updateSettings($data)
    {
        $settings = self::sanitizeSettings($data);
        update_option('sync_basalam_settings', $settings);
    }
    public static function saveOauthData()
    {
        $isVendor  = isset($_GET['is_vendor']) ? sanitize_text_field(wp_unslash($_GET['is_vendor'])) : true;
        $vendorId = sanitize_text_field(isset($_GET['vendor_id'])) ? sanitize_text_field(intval($_GET['vendor_id'])) : null;
        $accessToken = sanitize_text_field(isset($_GET['access_token'])) ? sanitize_text_field(wp_unslash($_GET['access_token'])) : null;
        $refreshToken = sanitize_text_field(isset($_GET['refresh_token'])) ? sanitize_text_field(wp_unslash($_GET['refresh_token'])) : null;
        $expiresIn = sanitize_text_field(isset($_GET['expires_in'])) ? sanitize_text_field(intval($_GET['expires_in'])) : null;
        if ($isVendor == 'false') {
            $data = [
                SyncBasalamAdminSettings::IS_VENDOR => false,
            ];
            self::updateSettings($data);
            wp_redirect(admin_url('admin.php?page=sync_basalam'));
            exit();
        }
        if ($isVendor == 'true' && (!$vendorId || !$accessToken || !$refreshToken || !$expiresIn)) {
            echo '
            <div class="notice notice-error">
                <p class="basalam-p">اطلاعات غرفه در دسترس نیست. لطفا از تنظیمات صحیح و اتصال به باسلام اطمینان حاصل کنید.</p>
            </div>
            ';
            return false;
        }
        $data = [
            SyncBasalamAdminSettings::VENDOR_ID => $vendorId,
            SyncBasalamAdminSettings::IS_VENDOR => true,
            SyncBasalamAdminSettings::TOKEN => $accessToken,
            SyncBasalamAdminSettings::REFRESH_TOKEN => $refreshToken,
            SyncBasalamAdminSettings::EXPIRE_TOKEN_TIME => $expiresIn,
        ];
        self::updateSettings($data);

        $webhookService = new SyncBasalamWebhookService();
        $webhookService->setupWebhook();

        wp_redirect(admin_url('admin.php?page=sync_basalam'));
        exit();
    }
    static function generateWebhookToken($length = 50)
    {
        $webhookToken = substr(bin2hex(random_bytes($length)), 0, $length);
        $data = [
            SyncBasalamAdminSettings::WEBHOOK_HEADER_TOKEN => $webhookToken,
        ];
        self::updateSettings($data);
        return $webhookToken;
    }

    public static function getEffectiveTasksPerMinute()
    {
        $isAuto = self::getSettings(self::TASKS_PER_MINUTE_AUTO) == 'true';

        if ($isAuto) {
            $monitor = SyncBasalamSystemResourceMonitor::getInstance();
            return $monitor->calculateOptimalTasksPerMinute();
        } else {
            return self::getSettings(self::TASKS_PER_MINUTE) ?? 10;
        }
    }
}
