<div class="bug-monitor-settings-wrapper">
      <nav class="bug-monitor-settings-nav">
            <a href="#functional" class="active"><?php echo Bug_Monitor_Helper::get_icon('functional');?><?php esc_html_e('Functional issues', 'bug-monitor');?></a>
            <a href="#js"><?php echo Bug_Monitor_Helper::get_icon('js');?><?php esc_html_e('JavaScript', 'bug-monitor');?></a>
            <a href="#network"><?php echo Bug_Monitor_Helper::get_icon('network');?><?php esc_html_e('Network', 'bug-monitor');?></a>
            <a href="#seo"><?php echo Bug_Monitor_Helper::get_icon('seo');?><?php esc_html_e('SEO problems', 'bug-monitor');?></a>
            <a href="#ui"><?php echo Bug_Monitor_Helper::get_icon('ui');?><?php esc_html_e('UI problems', 'bug-monitor');?></a>
            <a href="#ux"><?php echo Bug_Monitor_Helper::get_icon('ux');?><?php esc_html_e('UX problems', 'bug-monitor');?></a>
            <a href="#webvitals"><?php echo Bug_Monitor_Helper::get_icon('webvitals');?><?php esc_html_e('Web Vital issues', 'bug-monitor');?></a>
            <a href="#wordpress"><?php echo Bug_Monitor_Helper::get_icon('php');?><?php esc_html_e('WordPress', 'bug-monitor');?></a>
            <a href="#notifications"><?php echo Bug_Monitor_Helper::get_icon('notifications');?><?php esc_html_e('Notifications', 'bug-monitor');?></a>
            <a href="#system"><?php echo Bug_Monitor_Helper::get_icon('system');?><?php esc_html_e('System', 'bug-monitor');?></a>
      </nav>

      <div class="bug-monitor-settings-group bug-monitor-settings-group-functional">
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Unresponsive buttons/links', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('Activating this option allows BugMonitor to report any buttons or links that are unresponsive when clicked by a user.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="functional_non_responsive_button" name="functional/non_responsive_button" value="on" <?php Bug_Monitor_Helper::maybe_checked('functional/non_responsive_button');?>>
                        <label for="functional_non_responsive_button"></label>
                  </div>
            </div>
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Form submission issues', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('BugMonitor will identify and report issues related to form submissions on your site, such as JavaScript errors or incorrect captcha settings, preventing successful submission.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="functional_form_submission" name="functional/form_submission" value="on" <?php Bug_Monitor_Helper::maybe_checked('functional/form_submission');?>>
                        <label for="functional_form_submission"></label>
                  </div>
            </div>
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Form abandonment issues', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('BugMonitor will identify and report when a user starts filling out a form but cannot submit it for some reason and leaves the site.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="functional_form_abandonment" name="functional/form_abandonment" value="on" <?php Bug_Monitor_Helper::maybe_checked('functional/form_abandonment');?>>
                        <label for="functional_form_abandonment"></label>
                  </div>
            </div>
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Broken links', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('Beyond just logging 404 errors, this feature helps pinpoint the location of broken links on your site, enabling you to fix them more efficiently.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="functional_broken_link" name="functional/broken_link" value="on" <?php Bug_Monitor_Helper::maybe_checked('functional/broken_link');?>>
                        <label for="functional_broken_link"></label>
                  </div>
            </div>

      </div>

      <div class="bug-monitor-settings-group bm-hidden bug-monitor-settings-group-network">
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('HTTP errors', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('BugMonitor can report various HTTP errors such as 404, 403, and 500, which occur on your site, including those involving third-party resources.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="network_http" name="network/http" value="on" <?php Bug_Monitor_Helper::maybe_checked('network/http');?>>
                        <label for="network_http"></label>
                  </div>
            </div>
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Mixed content', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('If your site uses HTTPS but contains resources loaded over HTTP, browsers may block them. Enabling this option allows BugMonitor to report these mixed content issues.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="network_mixed_content" name="network/mixed_content" value="on" <?php Bug_Monitor_Helper::maybe_checked('network/mixed_content');?>>
                        <label for="network_mixed_content"></label>
                  </div>
            </div>
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('CSP errors', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('This feature enables BugMonitor to report instances where resources have been blocked due to the Content Security Policy (CSP) violations.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="network_csp" name="network/csp" value="on" <?php Bug_Monitor_Helper::maybe_checked('network/csp');?>>
                        <label for="network_csp"></label>
                  </div>
            </div>
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Insecure connection', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('Activate this feature to receive alerts when your site is loaded through an insecure connection without SSL encryption.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="network_insecure" name="network/insecure" value="on" <?php Bug_Monitor_Helper::maybe_checked('network/insecure');?>>
                        <label for="network_insecure"></label>
                  </div>
            </div>

      </div>

      <div class="bug-monitor-settings-group bm-hidden bug-monitor-settings-group-seo">
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Title issues', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('Having a proper title is crucial for both SEO and user experience. In WordPress, titles are often dynamically generated, which can result in titles being too short, too long, or even missing.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="seo_title" name="seo/title" value="on" <?php Bug_Monitor_Helper::maybe_checked('seo/title');?>>
                        <label for="seo_title"></label>
                  </div>
            </div>
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Meta description issues', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('A proper meta description is vital for SEO. In WordPress, these descriptions are usually dynamically generated, which may lead to them being too short, too long, or entirely absent.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="seo_description" name="seo/description" value="on" <?php Bug_Monitor_Helper::maybe_checked('seo/description');?>>
                        <label for="seo_description"></label>
                  </div>
            </div>
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Image issues', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('For optimal SEO and site usability, proper alt attributes are essential for every image. However, alt tags are often missing or inappropriate, especially for dynamically added images.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="seo_image" name="seo/image" value="on" <?php Bug_Monitor_Helper::maybe_checked('seo/image');?>>
                        <label for="seo_image"></label>
                  </div>
            </div>

      </div>

      <div class="bug-monitor-settings-group bm-hidden bug-monitor-settings-group-ux">
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Unresponsive elements', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('BugMonitor flags elements that appear clickable but do not respond when interacted with. This feature helps in identifying and addressing UI elements that might confuse or frustrate users, ensuring a more intuitive and responsive website experience.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="ux_non_responsive_element" name="ux/non_responsive_element" value="on" <?php Bug_Monitor_Helper::maybe_checked('ux/non_responsive_element');?>>
                        <label for="ux_non_responsive_element"></label>
                  </div>
            </div>
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Slow response', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('This feature monitors and reports on slow Time to First Byte (TTFB) or sluggish AJAX responses. Timely reporting of these issues is essential for optimizing site speed and enhancing the overall user experience, especially for dynamic content.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="ux_slow_response" name="ux/slow_response" value="on" <?php Bug_Monitor_Helper::maybe_checked('ux/slow_response');?>>
                        <label for="ux_slow_response"></label>
                  </div>
            </div>
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Bounce rate', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('BugMonitor tracks and reports the bounce rate, which indicates the percentage of visitors who leave the site after viewing only one page. This metric is crucial for understanding user engagement and identifying potential issues with site content or usability.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="ux_bounce_rate" name="ux/bounce_rate" value="on" <?php Bug_Monitor_Helper::maybe_checked('ux/bounce_rate');?>>
                        <label for="ux_bounce_rate"></label>
                  </div>
            </div>

      </div>

      <div class="bug-monitor-settings-group bm-hidden bug-monitor-settings-group-ui">
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Hard to read text', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('BugMonitor identifies instances of hard-to-read text, such as poor font size or color contrast. This feature is crucial for recognizing and addressing text clarity issues, thereby improving site accessibility.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="ui_hard_read_text" name="ui/hard_read_text" value="on" <?php Bug_Monitor_Helper::maybe_checked('ui/hard_read_text');?>>
                        <label for="ui_hard_read_text"></label>
                  </div>
            </div>
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Too close clickable elements', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('This feature reports clickable elements that are too close to each other, which can potentially cause user navigation errors. Highlighting these issues helps in enhancing the user experience, particularly on touch devices.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="ui_too_close_clickable" name="ui/too_close_clickable" value="on" <?php Bug_Monitor_Helper::maybe_checked('ui/too_close_clickable');?>>
                        <label for="ui_too_close_clickable"></label>
                  </div>
            </div>
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Layout issues', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('BugMonitor detects and reports layout problems like misalignments or overlapping elements. Identifying these issues is key to maintaining a professional and user-friendly website appearance.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="ui_layout" name="ui/layout" value="on" <?php Bug_Monitor_Helper::maybe_checked('ui/layout');?>>
                        <label for="ui_layout"></label>
                  </div>
            </div>
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Content obstruction', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('Content Obstruction refers to elements overlapping or covering content, hindering site usability, especially on mobile. BugMonitor detects and reports these issues to improve accessibility and user experience.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="ui_content_obstruction" name="ui/content_obstruction" value="on" <?php Bug_Monitor_Helper::maybe_checked('ui/content_obstruction');?>>
                        <label for="ui_content_obstruction"></label>
                  </div>
            </div>

      </div>

      <div class="bug-monitor-settings-group bm-hidden bug-monitor-settings-group-js">
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('JS errors', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('JavaScript errors often occur silently. When this option is enabled, BugMonitor will report any JavaScript errors that occur during a site visit.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="js_error" name="js/error" value="on" <?php Bug_Monitor_Helper::maybe_checked('js/error');?>>
                        <label for="js_error"></label>
                  </div>
            </div>

      </div>

      <div class="bug-monitor-settings-group bm-hidden bug-monitor-settings-group-wordpress">
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Uptime monitoring', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('BugMonitor tracks your website\'s availability, alerting you to downtime instances, ensuring prompt awareness and response.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <?php if (Bug_Monitor::check_option('activated', '1', '!=')):?>
                              <div class="bm-get-subscription">
                                    <?php echo sprintf(esc_html__('This feature requires an active subscription. %s Subscribe now%s', 'bug-monitor'), '<a href="https://bug-monitor.com/pricing/" class="bm-btn bm-btn-brand" target="_blank">', '</a>');?>
                              </div>
                        <?php else:?>
                        <input type="checkbox" class="bm-autosave"  id="uptime" name="server/uptime" value="on" <?php Bug_Monitor_Helper::maybe_checked('server/uptime');?>>
                        <label for="uptime"></label>
                        <?php endif;?>
                  </div>
            </div>

            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('PHP errors', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('Sometimes WordPress plugins or themes can cause PHP errors. Ideally, we would notice them immediately after updating the theme or plugins, but BugMonitor can report them even if they occur silently, such as during form submissions or AJAX requests.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="php_error" name="php/error" value="on" <?php Bug_Monitor_Helper::maybe_checked('php/error');?>>
                        <label for="php_error"></label>
                  </div>
            </div>

            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('PHP warnings', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('This option allows you to monitor PHP warnings. These are non-fatal errors that don\'t prevent page loading but can cause issues in functionality. Since they\'re not as noticeable as fatal errors, detecting them can be more challenging.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="php_warning" name="php/warning" value="on" <?php Bug_Monitor_Helper::maybe_checked('php/warning');?>>
                        <label for="php_warning"></label>
                  </div>
            </div>

            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Deactivate Broken Plugins', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('Broken plugins can prevent access to the admin area. If you enable this option, BugMonitor will automatically disable any plugins that cause a fatal error in the admin area.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="php_deactivate_plugin" name="php/deactivate_plugin" value="on" <?php Bug_Monitor_Helper::maybe_checked('php/deactivate_plugin');?>>
                        <label for="php_deactivate_plugin"></label>
                  </div>
            </div>

            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Redirect loop', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('This feature automatically identifies and records instances of redirect loops, helping maintain website stability and enhancing user experience by promptly flagging potential navigation issues.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="php_redirect_loop" name="php/redirect_loop" value="on" <?php Bug_Monitor_Helper::maybe_checked('php/redirect_loop');?>>
                        <label for="php_redirect_loop"></label>
                  </div>
            </div>

            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Malicious redirect', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('This feature automatically identifies and records malicious redirects, which is crucial when your site has been hacked and traffic is being redirected to third-party URLs.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="php_malicious_redirect" name="php/malicious_redirect" value="on" <?php Bug_Monitor_Helper::maybe_checked('php/malicious_redirect');?>>
                        <label for="php_malicious_redirect"></label>
                  </div>
            </div>

            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Email sending errors', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('This feature can detect errors that occur while WordPress is sending an email.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="php_email_sending_error" name="php/email_sending_error" value="on" <?php Bug_Monitor_Helper::maybe_checked('php/email_sending_error');?>>
                        <label for="php_email_sending_error"></label>
                  </div>
            </div>
      </div>


      <div class="bug-monitor-settings-group bm-hidden bug-monitor-settings-group-webvitals">
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('LCP', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('BugMonitor tracks the Largest Contentful Paint, a key WebVital that measures loading performance. It helps in identifying the time taken for the largest content element to load, which is crucial for assessing user experience during site visits.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="webvitals_lcp" name="webvitals/lcp" value="on" <?php Bug_Monitor_Helper::maybe_checked('webvitals/lcp');?>>
                        <label for="webvitals_lcp"></label>
                  </div>
            </div>
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('FCP', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('This feature monitors the First Contentful Paint, which measures the time from navigation to when any part of the page\s content is rendered on the screen. It\'s an important metric for understanding perceived load speed from the user\'s perspective.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="webvitals_fcp" name="webvitals/fcp" value="on" <?php Bug_Monitor_Helper::maybe_checked('webvitals/fcp');?>>
                        <label for="webvitals_fcp"></label>
                  </div>
            </div>
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('CLS', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('BugMonitor evaluates the Cumulative Layout Shift, a vital metric that quantifies the amount of unexpected layout shift of visual page content. Monitoring CLS is essential for ensuring a stable and visually consistent browsing experience for users.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="webvitals_cls" name="webvitals/cls" value="on" <?php Bug_Monitor_Helper::maybe_checked('webvitals/cls');?>>
                        <label for="webvitals_cls"></label>
                  </div>
            </div>
      </div>

      <div class="bug-monitor-settings-group bm-hidden bug-monitor-settings-group-notifications">
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Enable e-mail notifications', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('You can enable notifications to receive a daily summary of minor issues and instant notifications for critical errors.', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="notification_status" name="notification/status" value="on" <?php Bug_Monitor_Helper::maybe_checked('notification/status');?>>
                        <label for="notification_status"></label>
                  </div>
            </div>
            <div class="bug-monitor-settings-row" data-depend-on="notification/status" data-depend-value="on">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('E-mail notifications', 'bug-monitor');?></h3>
                        <div class="bug-monitor-notification-endpoints" data-type="email">
                              <div class="bm-loading"></div>
                        </div>
                        <div class="bm-add-notification-endpoint-wrapper">
                              <h4><?php esc_html_e('Add new e-mail address', 'bug-monitor');?></h4>
                              <form class="bm-add-notification-endpoint-inner bm-notification-endpoint">
                                    <input type="hidden" name="action" value="bug_monitor">
                                    <input type="hidden" name="bmaction" value="notifications/save">
                                    <input type="hidden" name="type" value="email">
                                    <label><?php esc_html_e('E-mail:', 'bug-monitor');?><input type="email" name="email" required></label>
                                    <a href="#" class="bm-btn bm-btn-interacitve bm-save-endpoint"><?php esc_html_e('Save', 'bug-monitor');?></a>
                              </form>
                        </div>
                  </div>
            </div>
            <div class="bug-monitor-settings-row" data-depend-on="notification/status" data-depend-value="on">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Push notifications', 'bug-monitor');?></h3>
                        <div class="bug-monitor-notification-endpoints" data-type="push">
                              <div class="bm-loading"></div>
                        </div>
                        <div class="bug-monitor-notification-qr-wrapper">
                              <h4><?php esc_html_e('Add new device', 'bug-monitor');?></h4>
                              <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII=">
                        </div>
                  </div>
            </div>
            <div class="bug-monitor-settings-row" data-depend-on="notification/status" data-depend-value="on">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Notification webhooks', 'bug-monitor');?></h3>
                        <div class="bug-monitor-notification-endpoints" data-type="webhook">
                              <div class="bm-loading"></div>
                        </div>
                        <div class="bm-add-notification-endpoint-wrapper">
                              <h4><?php esc_html_e('Add new webhook', 'bug-monitor');?></h4>
                              <form class="bm-add-notification-endpoint-inner bm-notification-endpoint">
                                    <input type="hidden" name="action" value="bug_monitor">
                                    <input type="hidden" name="bmaction" value="notifications/save">
                                    <input type="hidden" name="type" value="webhook">
                                    <label class="bm-flex-wide"><?php esc_html_e('URL:', 'bug-monitor');?><input type="url" name="url" class="bm-flex-wide" required></label>
                                    <label>
                                          <?php esc_html_e('Request type:', 'bug-monitor');?>
                                          <select name="method">
                                                <option value="POST"><?php esc_html_e('POST', 'bug-monitor');?></option>
                                                <option value="GET"><?php esc_html_e('GET', 'bug-monitor');?></option>
                                          </select>
                                    </label>
                                    <a href="#" class="bm-btn bm-btn-interacitve bm-save-endpoint"><?php esc_html_e('Save', 'bug-monitor');?></a>
                              </form>
                              <div class="bm-notification-info">
                                    <?php esc_html_e('You can use [CATEGORY], [CATEGORY_LABEL], [LEVEL], [LEVEL_LABEL], [EVENT_COUNT], [MESSAGE] and [DETAILS_URL] variables.', 'bug-monitor');?><br>
                                    <?php esc_html_e('Example: https://my-service.com/webhook/?cat=[CATEGORY]&cat_label=[CATEGORY_LABEL]&level=[LEVEL]&level_label=[LEVEL_LABEL]&count=[EVENT_COUNT]&message=[MESSAGE]&link=[DETAILS_URL]', 'bug-monitor');?>
                              </div>
                        </div>
                  </div>
            </div>
      </div>

      <div class="bug-monitor-settings-group bm-hidden bug-monitor-settings-group-system">
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Reset Logs', 'bug-monitor');?></h3>
                        <p>
                              <?php esc_html_e('You can clear all logs here with a single click. Please note that ignored events will also be cleared, so they may reappear in reports.', 'bug-monitor');?>
                        </p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <a href="#reset-system-trigger" class="bm-btn bm-interactive" data-text="<?php esc_html_e('Are you certain about clearing all logs?', 'bug-monitor');?>"><?php esc_html_e('Reset', 'bug-monitor');?></a>
                  </div>
            </div>
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Event Retention Period', 'bug-monitor');?></h3>
                        <p>
                              <?php esc_html_e('You can set how long to keep reported issues.', 'bug-monitor');?>
                        </p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <select class="bm-autosave" id="event-retention" name="system/event_retention">
                              <option value="7"<?php Bug_Monitor_Helper::maybe_selected('system/event_retention', '7');?>><?php esc_html_e('7 days', 'bug-monitor');?></option>
                              <option value="30"<?php Bug_Monitor_Helper::maybe_selected('system/event_retention', '30');?>><?php esc_html_e('30 days', 'bug-monitor');?></option>
                              <option value="90"<?php Bug_Monitor_Helper::maybe_selected('system/event_retention', '90');?>><?php esc_html_e('90 days', 'bug-monitor');?></option>
                              <option value="365"<?php Bug_Monitor_Helper::maybe_selected('system/event_retention', '365');?>><?php esc_html_e('1 year', 'bug-monitor');?></option>
                              <option value=""<?php Bug_Monitor_Helper::maybe_selected('system/event_retention', '');?>><?php esc_html_e('Indefinitely', 'bug-monitor');?></option>
                        </select>
                  </div>
            </div>
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('Disable Toolbar Icon', 'bug-monitor');?></h3>
                        <p><?php esc_html_e('You can disable BugMonitor icon in the admin bar', 'bug-monitor');?></p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <input type="checkbox" class="bm-autosave"  id="disable_toolbar" name="system/disable_toolbar" value="on"<?php Bug_Monitor_Helper::maybe_checked('system/disable_toolbar');?>>
                        <label for="disable_toolbar"></label>
                  </div>
            </div>
            <div class="bug-monitor-settings-row">
                  <div class="bug-monitor-settings-col">
                        <h3><?php esc_html_e('License status', 'bug-monitor');?></h3>
                        <p>
                              <?php if (Bug_Monitor::check_option('activated', 1)):?>
                                    <?php esc_html_e('Your license is activated and working correctly. If you would like to switch licenses, you can disconnect the current license here.', 'bug-monitor');?>
                              <?php else:?>
                                    <?php esc_html_e('Your license is not activated. Connect your site to activate your license and use the premium features.', 'bug-monitor');?>
                              <?php endif;?>
                              <br><br>
                              <?php if (Bug_Monitor::check_option('activated', 1)):?>
                                    <a href="#" id="bug-monitor-disconnect-license" class="bm-btn bm-interactive"><?php esc_html_e('Disconnect', 'bug-monitor');?></a>
                              <?php else:?>
                                    <a href="<?php echo add_query_arg(array('site' => home_url(), 'site-key' => Bug_Monitor_API::get_site_key(), 'plugin' => 'bugmonitor', 'redirect_to' => Bug_Monitor_Helper::get_dashbord_url()), 'https://musthaveplugins.com/my-account/api/connect/');?>" class="bm-btn bm-interactive"><?php esc_html_e('Connect', 'bug-monitor');?></a>
                              <?php endif;?>
                        </p>
                  </div>
                  <div class="bug-monitor-settings-col">
                        <?php if (Bug_Monitor::check_option('activated', 1)):?>
                              <div class="bug-monitor-license-status active"><?php esc_html_e('Active', 'bug-monitor');?></div>
                        <?php else:?>
                              <div class="bug-monitor-license-status"><?php esc_html_e('Not connected', 'bug-monitor');?></div>
                        <?php endif;?>
                  </div>
            </div>
      </div>
</div>